/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

public class KeyHasher {
    private final Object[] objects;

    public KeyHasher(int n) {
        this.objects = new Object[n];
    }

    public void setObject(int n, Object object) {
        this.objects[n] = object;
    }

    public Object getObject(int n) {
        return this.objects[n];
    }

    public static Object buildHashKey(Object[] objectArray, int[] nArray) {
        if (nArray.length == 1) {
            return objectArray[nArray[0]];
        }
        KeyHasher keyHasher = new KeyHasher(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            keyHasher.setObject(i, objectArray[nArray[i]]);
        }
        return keyHasher;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.objects.length; ++i) {
            n += this.objects[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeyHasher)) {
            return false;
        }
        KeyHasher keyHasher = (KeyHasher)object;
        if (keyHasher.objects.length != this.objects.length) {
            return false;
        }
        for (int i = 0; i < this.objects.length; ++i) {
            if (keyHasher.objects[i].equals(this.objects[i])) continue;
            return false;
        }
        return true;
    }
}

