/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.github.fge.lambdas.Throwing;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.jmap.api.filtering.Rule;

public class RuleDTO {
    private final String id;
    private final String name;
    private final ConditionGroupDTO conditionGroupDTO;
    private final ActionDTO actionDTO;

    public static ImmutableList<Rule> toRules(List<RuleDTO> ruleDTOList) {
        Preconditions.checkNotNull(ruleDTOList);
        return (ImmutableList)ruleDTOList.stream().map(RuleDTO::toRule).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<RuleDTO> from(List<Rule> rules) {
        Preconditions.checkNotNull(rules);
        return (ImmutableList)rules.stream().map(RuleDTO::from).collect(ImmutableList.toImmutableList());
    }

    public static RuleDTO from(Rule rule) {
        return new RuleDTO(rule.getId().asString(), rule.getName(), ConditionGroupDTO.from(rule.getConditionGroup()), ActionDTO.from(rule.getAction()));
    }

    public RuleDTO(String id, String name, ConditionGroupDTO conditionGroupDTO, ActionDTO actionDTO) {
        Preconditions.checkNotNull((Object)id);
        this.name = name;
        this.conditionGroupDTO = conditionGroupDTO;
        this.actionDTO = actionDTO;
        this.id = id;
    }

    @JsonCreator
    public RuleDTO(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="condition") Optional<ConditionDTO> conditionDTO, @JsonProperty(value="conditionGroup") Optional<ConditionGroupDTO> conditionGroupDTO, @JsonProperty(value="action") ActionDTO actionDTO) {
        Preconditions.checkNotNull((Object)id);
        this.name = name;
        this.conditionGroupDTO = conditionGroupDTO.isPresent() ? conditionGroupDTO.orElseThrow() : new ConditionGroupDTO(Rule.ConditionCombiner.AND, (List<ConditionDTO>)ImmutableList.of((Object)conditionDTO.orElseThrow(() -> new RuntimeException("Condition field in the rule with id " + id + " is missing"))));
        this.actionDTO = actionDTO;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ConditionGroupDTO getConditionGroup() {
        return this.conditionGroupDTO;
    }

    public ActionDTO getAction() {
        return this.actionDTO;
    }

    public Rule toRule() {
        return Rule.builder().id(Rule.Id.of(this.id)).name(this.name).conditionGroup(this.conditionGroupDTO.toConditionGroup()).action(this.actionDTO.toAction()).build();
    }

    public final boolean equals(Object o) {
        if (o instanceof RuleDTO) {
            RuleDTO ruleDTO = (RuleDTO)o;
            return Objects.equals(this.id, ruleDTO.id) && Objects.equals(this.name, ruleDTO.name) && Objects.equals(this.conditionGroupDTO, ruleDTO.conditionGroupDTO) && Objects.equals(this.actionDTO, ruleDTO.actionDTO);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.name, this.conditionGroupDTO, this.actionDTO);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }

    public static class ConditionGroupDTO {
        private final Rule.ConditionCombiner conditionCombiner;
        private final List<ConditionDTO> conditionDTOs;

        @JsonCreator
        public ConditionGroupDTO(@JsonProperty(value="conditionCombiner") Rule.ConditionCombiner conditionCombiner, @JsonProperty(value="conditions") List<ConditionDTO> conditionDTOs) {
            this.conditionCombiner = conditionCombiner;
            this.conditionDTOs = conditionDTOs;
        }

        public Rule.ConditionCombiner getConditionCombiner() {
            return this.conditionCombiner;
        }

        public List<ConditionDTO> getConditions() {
            return this.conditionDTOs;
        }

        public Rule.ConditionGroup toConditionGroup() {
            return Rule.ConditionGroup.of(this.conditionCombiner, (List)this.conditionDTOs.stream().map(ConditionDTO::toCondition).collect(ImmutableList.toImmutableList()));
        }

        public static ConditionGroupDTO from(Rule.ConditionGroup conditionGroup) {
            return new ConditionGroupDTO(conditionGroup.getConditionCombiner(), (List)conditionGroup.getConditions().stream().map(ConditionDTO::from).collect(ImmutableList.toImmutableList()));
        }

        public final boolean equals(Object o) {
            if (o instanceof ConditionGroupDTO) {
                ConditionGroupDTO other = (ConditionGroupDTO)o;
                return Objects.equals((Object)this.conditionCombiner, (Object)other.conditionCombiner) && Objects.equals(this.conditionDTOs, other.conditionDTOs);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.conditionCombiner, this.conditionDTOs});
        }
    }

    public static class ActionDTO {
        private final AppendInMailboxesDTO appendIn;
        private final boolean seen;
        private final boolean important;
        private final boolean reject;
        private final List<String> keyworkds;
        private Optional<ForwardDTO> forwardTo;

        public static ActionDTO from(Rule.Action action) {
            return new ActionDTO(AppendInMailboxesDTO.from(action.getAppendInMailboxes()), action.isMarkAsSeen(), action.isMarkAsImportant(), action.isReject(), (List<String>)ImmutableList.copyOf(action.getWithKeywords()), action.getForward().map(ForwardDTO::from));
        }

        @JsonCreator
        public ActionDTO(@JsonProperty(value="appendIn") AppendInMailboxesDTO appendIn, @JsonProperty(value="seen") boolean seen, @JsonProperty(value="important") boolean important, @JsonProperty(value="reject") boolean reject, @JsonProperty(value="keywords") @JsonSetter(nulls=Nulls.AS_EMPTY) List<String> keyworkds, @JsonProperty(value="forwardTo") Optional<ForwardDTO> forwardTo) {
            this.appendIn = appendIn;
            this.keyworkds = keyworkds;
            this.seen = seen;
            this.important = important;
            this.reject = reject;
            this.forwardTo = forwardTo;
        }

        public AppendInMailboxesDTO getAppendIn() {
            return this.appendIn;
        }

        public boolean isSeen() {
            return this.seen;
        }

        public boolean isImportant() {
            return this.important;
        }

        public boolean isReject() {
            return this.reject;
        }

        public List<String> getKeyworkds() {
            return this.keyworkds;
        }

        public Optional<ForwardDTO> getForwardTo() {
            return this.forwardTo;
        }

        public Rule.Action toAction() {
            return Rule.Action.of(this.appendIn.toAppendInMailboxes(), this.isSeen(), this.isImportant(), this.isReject(), this.getKeyworkds(), this.forwardTo.map(ForwardDTO::toForward));
        }

        public final boolean equals(Object o) {
            if (o instanceof ActionDTO) {
                ActionDTO actionDTO = (ActionDTO)o;
                return Objects.equals(this.appendIn, actionDTO.appendIn) && Objects.equals(this.seen, actionDTO.seen) && Objects.equals(this.important, actionDTO.important) && Objects.equals(this.reject, actionDTO.reject) && Objects.equals(this.keyworkds, actionDTO.keyworkds) && Objects.equals(this.forwardTo, actionDTO.forwardTo);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.appendIn, this.reject, this.seen, this.important, this.keyworkds, this.forwardTo);
        }

        public static class AppendInMailboxesDTO {
            private final List<String> mailboxIds;

            public static AppendInMailboxesDTO from(Rule.Action.AppendInMailboxes appendInMailboxes) {
                return new AppendInMailboxesDTO((List<String>)appendInMailboxes.getMailboxIds());
            }

            @JsonCreator
            public AppendInMailboxesDTO(@JsonProperty(value="mailboxIds") List<String> mailboxIds) {
                this.mailboxIds = ImmutableList.copyOf(mailboxIds);
            }

            public List<String> getMailboxIds() {
                return this.mailboxIds;
            }

            public Rule.Action.AppendInMailboxes toAppendInMailboxes() {
                return Rule.Action.AppendInMailboxes.withMailboxIds(this.mailboxIds);
            }

            public final boolean equals(Object o) {
                if (o instanceof AppendInMailboxesDTO) {
                    AppendInMailboxesDTO that = (AppendInMailboxesDTO)o;
                    return Objects.equals(this.mailboxIds, that.mailboxIds);
                }
                return false;
            }

            public final int hashCode() {
                return Objects.hash(this.mailboxIds);
            }
        }

        public static class ForwardDTO {
            private final List<String> addresses;
            private final boolean keepACopy;

            public static ForwardDTO from(Rule.Action.Forward forward) {
                return new ForwardDTO((List)forward.getAddresses().stream().map(MailAddress::asString).collect(ImmutableList.toImmutableList()), forward.isKeepACopy());
            }

            public ForwardDTO(@JsonProperty(value="addresses") List<String> addresses, @JsonProperty(value="keepACopy") boolean keepACopy) {
                this.addresses = addresses;
                this.keepACopy = keepACopy;
            }

            public List<String> getAddresses() {
                return this.addresses;
            }

            public boolean isKeepACopy() {
                return this.keepACopy;
            }

            public Rule.Action.Forward toForward() {
                return Rule.Action.Forward.to((Collection)this.addresses.stream().map(Throwing.function(MailAddress::new)).collect(ImmutableList.toImmutableList())).keepACopy(this.keepACopy);
            }

            public final boolean equals(Object o) {
                if (o instanceof ForwardDTO) {
                    ForwardDTO that = (ForwardDTO)o;
                    return Objects.equals(this.addresses, that.addresses) && Objects.equals(this.keepACopy, that.keepACopy);
                }
                return false;
            }

            public final int hashCode() {
                return Objects.hash(this.addresses, this.keepACopy);
            }
        }
    }

    public static class ConditionDTO {
        private final String field;
        private final String comparator;
        private final String value;

        public static ConditionDTO from(Rule.Condition condition) {
            return new ConditionDTO(condition.getField().asString(), condition.getComparator().asString(), condition.getValue());
        }

        @JsonCreator
        public ConditionDTO(@JsonProperty(value="field") String field, @JsonProperty(value="comparator") String comparator, @JsonProperty(value="value") String value) {
            this.field = field;
            this.comparator = comparator;
            this.value = value;
        }

        public String getField() {
            return this.field;
        }

        public String getComparator() {
            return this.comparator;
        }

        public String getValue() {
            return this.value;
        }

        public Rule.Condition toCondition() {
            return Rule.Condition.of(Rule.Condition.Field.of(this.field), Rule.Condition.Comparator.of(this.comparator), this.value);
        }

        public final boolean equals(Object o) {
            if (o instanceof ConditionDTO) {
                ConditionDTO other = (ConditionDTO)o;
                return Objects.equals(this.field, other.field) && Objects.equals(this.comparator, other.comparator) && Objects.equals(this.value, other.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.field, this.comparator, this.value);
        }
    }
}

