/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.core.Username;
import org.apache.james.jmap.mail.Mailbox;
import org.apache.james.jmap.mail.MailboxACL$;
import org.apache.james.jmap.mail.MailboxNamespace;
import org.apache.james.jmap.mail.MailboxRights;
import org.apache.james.jmap.mail.MailboxRights$;
import org.apache.james.jmap.mail.MailboxValidation;
import org.apache.james.jmap.mail.MailboxValidation$;
import org.apache.james.jmap.mail.NamespaceFactory;
import org.apache.james.jmap.mail.Quota;
import org.apache.james.jmap.mail.QuotaId;
import org.apache.james.jmap.mail.Quotas;
import org.apache.james.jmap.mail.Rfc4314Rights$;
import org.apache.james.jmap.mail.Right;
import org.apache.james.jmap.mail.Right$;
import org.apache.james.jmap.mail.Rights;
import org.apache.james.jmap.mail.Rights$;
import org.apache.james.jmap.mail.SortOrder;
import org.apache.james.jmap.mail.SortOrder$;
import org.apache.james.jmap.mail.SortOrderProvider;
import org.apache.james.jmap.mail.Subscriptions;
import org.apache.james.jmap.mail.TotalEmails;
import org.apache.james.jmap.mail.TotalThreads;
import org.apache.james.jmap.mail.UnreadEmails;
import org.apache.james.jmap.mail.UnreadThreads;
import org.apache.james.jmap.utils.quotas.QuotaLoader;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;

@ScalaSignature(bytes="\u0006\u0005\u0005-g\u0001\u0002\t\u0012\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u00034\u0001\u0011\u0005A\u0007C\u0003C\u0001\u0011%1\tC\u0003X\u0001\u0011%\u0001\fC\u0003_\u0001\u0011%q\fC\u0003i\u0001\u0011%\u0011\u000eC\u0003p\u0001\u0011%\u0001\u000fC\u0003u\u0001\u0011%Q\u000fC\u0004\u0002\u0018\u0001!I!!\u0007\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!9\u0011q\u0005\u0001\u0005\u0002\u0005\u0015\u0005bBAL\u0001\u0011%\u0011\u0011\u0014\u0005\b\u0003\u007f\u0003A\u0011BAa\u00059i\u0015-\u001b7c_b4\u0015m\u0019;pefT!AE\n\u0002\t5\f\u0017\u000e\u001c\u0006\u0003)U\tAA[7ba*\u0011acF\u0001\u0006U\u0006lWm\u001d\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g-\u0001\bnC&d'm\u001c=NC:\fw-\u001a:\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d*\u0012aB7bS2\u0014w\u000e_\u0005\u0003S\u0019\u0012a\"T1jY\n|\u00070T1oC\u001e,'/\u0001\toC6,7\u000f]1dK\u001a\u000b7\r^8ssB\u0011A&L\u0007\u0002#%\u0011a&\u0005\u0002\u0011\u001d\u0006lWm\u001d9bG\u00164\u0015m\u0019;pef\f\u0011c]8si>\u0013H-\u001a:Qe>4\u0018\u000eZ3s!\ta\u0013'\u0003\u00023#\t\t2k\u001c:u\u001fJ$WM\u001d)s_ZLG-\u001a:\u0002\rqJg.\u001b;?)\u0011)dg\u000e\u001d\u0011\u00051\u0002\u0001\"B\u0012\u0005\u0001\u0004!\u0003\"\u0002\u0016\u0005\u0001\u0004Y\u0003\"B\u0018\u0005\u0001\u0004\u0001\u0004F\u0001\u0003;!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0004j]*,7\r\u001e\u0006\u0002\u007f\u00059!.Y6beR\f\u0017BA!=\u0005\u0019IeN[3di\u00069q-\u001a;S_2,Gc\u0001#K%B\u0019a$R$\n\u0005\u0019{\"AB(qi&|g\u000e\u0005\u0002&\u0011&\u0011\u0011J\n\u0002\u0005%>dW\rC\u0003L\u000b\u0001\u0007A*A\u0006nC&d'm\u001c=QCRD\u0007CA'Q\u001b\u0005q%BA('\u0003\u0015iw\u000eZ3m\u0013\t\tfJA\u0006NC&d'm\u001c=QCRD\u0007\"B*\u0006\u0001\u0004!\u0016AD7bS2\u0014w\u000e_*fgNLwN\u001c\t\u0003KUK!A\u0016\u0014\u0003\u001d5\u000b\u0017\u000e\u001c2pqN+7o]5p]\u0006aq-\u001a;T_J$xJ\u001d3feR\u0011\u0011\f\u0018\t\u0003YiK!aW\t\u0003\u0013M{'\u000f^(sI\u0016\u0014\b\"B/\u0007\u0001\u0004!\u0015\u0001\u0002:pY\u0016\f\u0011bZ3u%&<\u0007\u000e^:\u0015\u0005\u0001\u001c\u0007C\u0001\u0017b\u0013\t\u0011\u0017C\u0001\u0004SS\u001eDGo\u001d\u0005\u0006I\u001e\u0001\r!Z\u0001\u0012e\u0016\u001cx\u000e\u001c<f\u001b\u0006LGNY8y\u0003\u000ec\u0005CA'g\u0013\t9gJ\u0001\u0006NC&d'm\u001c=B\u00072\u000bAbZ3u\u001d\u0006lWm\u001d9bG\u0016$2A[7o!\ta3.\u0003\u0002m#\t\u0001R*Y5mE>Dh*Y7fgB\f7-\u001a\u0005\u0006\u0017\"\u0001\r\u0001\u0014\u0005\u0006'\"\u0001\r\u0001V\u0001\u000eO\u0016$\b+\u0019:f]R\u0004\u0016\r\u001e5\u0015\u0007E\u00148\u000fE\u0002\u001f\u000b2CQaS\u0005A\u00021CQaU\u0005A\u0002Q\u000b1\"Y2m\u000b:$(/_&fsR\u0019a/!\u0006\u0011\u0007]\fyAD\u0002y\u0003\u0017q1!_A\u0005\u001d\rQ\u0018q\u0001\b\u0004w\u0006\u0015ab\u0001?\u0002\u00049\u0019Q0!\u0001\u000e\u0003yT!a`\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012B\u0001\r\u001a\u0013\t1r#\u0003\u0002(+%\u0011qJJ\u0005\u0004\u0003\u001bq\u0015AC'bS2\u0014w\u000e_!D\u0019&!\u0011\u0011CA\n\u0005!)e\u000e\u001e:z\u0017\u0016L(bAA\u0007\u001d\")1K\u0003a\u0001)\u0006Yq-\u001a;NsJKw\r\u001b;t)!\tY\"!\t\u0002$\u0005\u0015\u0002c\u0001\u0017\u0002\u001e%\u0019\u0011qD\t\u0003\u001b5\u000b\u0017\u000e\u001c2pqJKw\r\u001b;t\u0011\u0015Y5\u00021\u0001M\u0011\u0015!7\u00021\u0001f\u0011\u0015\u00196\u00021\u0001U\u0003\u0019\u0019'/Z1uKRa\u00111FA$\u0003#\n\u0019&!\u0018\u0002rA1\u0011QFA\u001f\u0003\u0003j!!a\f\u000b\t\u0005E\u00121G\u0001\naV\u0014G.[:iKJT1\u0001IA\u001b\u0015\u0011\t9$!\u000f\u0002\t\r|'/\u001a\u0006\u0003\u0003w\tqA]3bGR|'/\u0003\u0003\u0002@\u0005=\"!B*N_:|\u0007c\u0001\u0017\u0002D%\u0019\u0011QI\t\u0003\u000f5\u000b\u0017\u000e\u001c2pq\"9\u0011\u0011\n\u0007A\u0002\u0005-\u0013aD7bS2\u0014w\u000e_'fi\u0006$\u0015\r^1\u0011\u00075\u000bi%C\u0002\u0002P9\u0013q\"T1jY\n|\u00070T3uC\u0012\u000bG/\u0019\u0005\u0006'2\u0001\r\u0001\u0016\u0005\b\u0003+b\u0001\u0019AA,\u00035\u0019XOY:de&\u0004H/[8ogB\u0019A&!\u0017\n\u0007\u0005m\u0013CA\u0007Tk\n\u001c8M]5qi&|gn\u001d\u0005\b\u0003?b\u0001\u0019AA1\u0003Q\tG\u000e\\'bS2\u0014w\u000e_3t\u001b\u0016$\u0018\rZ1uCB9\u00111MA6\u0019\u0006-c\u0002BA3\u0003O\u0002\"!`\u0010\n\u0007\u0005%t$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\nyGA\u0002NCBT1!!\u001b \u0011\u001d\t\u0019\b\u0004a\u0001\u0003k\n1\"];pi\u0006du.\u00193feB!\u0011qOAA\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014AB9v_R\f7OC\u0002\u0002\u0000M\tQ!\u001e;jYNLA!a!\u0002z\tY\u0011+^8uC2{\u0017\rZ3s))\tY#a\"\u0002\u0012\u0006M\u0015Q\u0013\u0005\b\u0003\u0013k\u0001\u0019AAF\u0003\tIG\rE\u0002N\u0003\u001bK1!a$O\u0005%i\u0015-\u001b7c_bLE\rC\u0003T\u001b\u0001\u0007A\u000bC\u0004\u0002t5\u0001\r!!\u001e\t\u000f\u0005US\u00021\u0001\u0002X\u0005\u0011\u0012N\\:uC:\u001c\u0017.\u0019;f\u001b\u0006LGNY8y)9\tY#a'\u0002\u001e\u0006}\u0015\u0011UAV\u0003{Cq!!#\u000f\u0001\u0004\tY\tC\u0003T\u001d\u0001\u0007A\u000bC\u0004\u0002t9\u0001\r!!\u001e\t\u000f\u0005\rf\u00021\u0001\u0002&\u0006qQ.Z:tC\u001e,W*\u00198bO\u0016\u0014\bcA\u0013\u0002(&\u0019\u0011\u0011\u0016\u0014\u0003\u001d5+7o]1hK6\u000bg.Y4fe\"9\u0011Q\u0016\bA\u0002\u0005=\u0016!E:b]&$\u0018N_3e\u0007>,h\u000e^3sgB!\u0011\u0011WA\\\u001d\ri\u00151W\u0005\u0004\u0003ks\u0015aD'bS2\u0014w\u000e_\"pk:$XM]:\n\t\u0005e\u00161\u0018\u0002\n'\u0006t\u0017\u000e^5{K\u0012T1!!.O\u0011\u001d\t)F\u0004a\u0001\u0003/\n1bZ3u!\u0006\u0014XM\u001c;JIR1\u00111YAd\u0003\u0013\u0004b!!\f\u0002>\u0005\u0015\u0007\u0003\u0002\u0010F\u0003\u0017Cq!a)\u0010\u0001\u0004\t)\u000bC\u0003T\u001f\u0001\u0007A\u000b")
public class MailboxFactory {
    private final MailboxManager mailboxManager;
    private final NamespaceFactory namespaceFactory;
    private final SortOrderProvider sortOrderProvider;

    private Option<Role> getRole(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(Role.from((String)mailboxPath.getName()).filter(x$1 -> mailboxPath.belongsTo(mailboxSession))));
    }

    private SortOrder getSortOrder(Option<Role> role2) {
        return (SortOrder)role2.map((Function1 & Serializable)role -> $this.sortOrderProvider.retrieveSortOrder((Role)role)).getOrElse((Function0 & Serializable)() -> SortOrder$.MODULE$.defaultSortOrder());
    }

    private Rights getRights(MailboxACL resolveMailboxACL) {
        return Rights$.MODULE$.fromACL(MailboxACL$.MODULE$.fromJava(resolveMailboxACL));
    }

    private MailboxNamespace getNamespace(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        return this.namespaceFactory.from(mailboxPath, mailboxSession);
    }

    private Option<MailboxPath> getParentPath(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        return ((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mailboxPath.getHierarchyLevels(mailboxSession.getPathDelimiter())).asScala().reverse()).drop(1)).headOption();
    }

    private MailboxACL.EntryKey aclEntryKey(MailboxSession mailboxSession) {
        return MailboxACL.EntryKey.createUserEntryKey((Username)mailboxSession.getUser());
    }

    private MailboxRights getMyRights(MailboxPath mailboxPath, MailboxACL resolveMailboxACL, MailboxSession mailboxSession) {
        boolean bl = mailboxPath.belongsTo(mailboxSession);
        if (bl) {
            return MailboxRights$.MODULE$.FULL();
        }
        if (!bl) {
            Seq<Right> rights = Rfc4314Rights$.MODULE$.fromJava(resolveMailboxACL.getEntries().getOrDefault(this.aclEntryKey(mailboxSession), MailboxACL.NO_RIGHTS)).toRights();
            return new MailboxRights(rights.contains((Object)Right$.MODULE$.Read()), rights.contains((Object)Right$.MODULE$.Insert()), rights.contains((Object)Right$.MODULE$.DeleteMessages()), rights.contains((Object)Right$.MODULE$.Seen()), rights.contains((Object)Right$.MODULE$.Write()), false, rights.contains((Object)Right$.MODULE$.DeleteMailbox()), rights.contains((Object)Right$.MODULE$.DeleteMailbox()), false);
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public SMono<Mailbox> create(MailboxMetaData mailboxMetaData, MailboxSession mailboxSession, Subscriptions subscriptions, Map<MailboxPath, MailboxMetaData> allMailboxesMetadata, QuotaLoader quotaLoader) {
        MailboxCounters.Sanitized sanitizedCounters = mailboxMetaData.getCounters().sanitize();
        Either<Exception, MailboxValidation> either = MailboxValidation$.MODULE$.validate(mailboxMetaData.getPath(), mailboxSession.getPathDelimiter(), sanitizedCounters.getUnseen(), sanitizedCounters.getUnseen(), sanitizedCounters.getCount(), sanitizedCounters.getCount());
        if (either instanceof Left) {
            Left left = (Left)either;
            Exception error = (Exception)left.value();
            return SMono$.MODULE$.error((Throwable)error);
        }
        if (either instanceof scala.util.Right) {
            scala.util.Right right = (scala.util.Right)either;
            MailboxValidation mailboxValidation = (MailboxValidation)right.value();
            return SMono$.MODULE$.fromPublisher(quotaLoader.getQuotas(mailboxMetaData.getPath())).map((Function1 & Serializable)quotas -> MailboxFactory.$anonfun$create$1(this, mailboxMetaData, mailboxSession, allMailboxesMetadata, subscriptions, mailboxValidation, ((Quotas)quotas).quotas()));
        }
        throw new MatchError(either);
    }

    public SMono<Mailbox> create(MailboxId id, MailboxSession mailboxSession, QuotaLoader quotaLoader, Subscriptions subscriptions) {
        return SMono$.MODULE$.apply(this.mailboxManager.getMailboxReactive(id, mailboxSession)).flatMap((Function1 & Serializable)messageManager -> SMono$.MODULE$.apply(messageManager.getMailboxCountersReactive(mailboxSession)).map((Function1 & Serializable)counters -> {
            MailboxCounters.Sanitized sanitizedCounters = counters.sanitize();
            return new Tuple2(counters, (Object)sanitizedCounters);
        }).flatMap((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                MailboxCounters.Sanitized sanitizedCounters = (MailboxCounters.Sanitized)tuple2._2();
                return this.instanciateMailbox(id, mailboxSession, quotaLoader, (MessageManager)messageManager, sanitizedCounters, subscriptions).map((Function1 & Serializable)mailbox -> mailbox);
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private SMono<Mailbox> instanciateMailbox(MailboxId id, MailboxSession mailboxSession, QuotaLoader quotaLoader, MessageManager messageManager, MailboxCounters.Sanitized sanitizedCounters, Subscriptions subscriptions) {
        SMono sMono;
        block4: {
            try {
                Either<Exception, MailboxValidation> either = MailboxValidation$.MODULE$.validate(messageManager.getMailboxPath(), mailboxSession.getPathDelimiter(), sanitizedCounters.getUnseen(), sanitizedCounters.getUnseen(), sanitizedCounters.getCount(), sanitizedCounters.getCount());
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Exception error = (Exception)left.value();
                    sMono = SMono$.MODULE$.error((Throwable)error);
                    break block4;
                }
                if (either instanceof scala.util.Right) {
                    scala.util.Right right = (scala.util.Right)either;
                    MailboxValidation mailboxValidation = (MailboxValidation)right.value();
                    sMono = SMono$.MODULE$.zip((Function1 & Serializable)array -> {
                        Object object = array[1];
                        return new Tuple2((Object)((Option)array[0]), (Object)new Quotas(object == null ? null : ((Quotas)object).quotas()));
                    }, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SMono[]{this.getParentId(messageManager, mailboxSession), SMono$.MODULE$.fromPublisher(quotaLoader.getQuotas(messageManager.getMailboxPath()))})).map((Function1 & Serializable)tuple2 -> {
                        MailboxACL resolvedACL = messageManager.getResolvedAcl(mailboxSession);
                        Option<Role> role = this.getRole(messageManager.getMailboxPath(), mailboxSession);
                        SortOrder sortOrder = this.getSortOrder(role);
                        Rights rights = this.getRights(resolvedACL);
                        MailboxNamespace namespace = this.getNamespace(messageManager.getMailboxPath(), mailboxSession);
                        MailboxRights myRights = this.getMyRights(messageManager.getMailboxPath(), resolvedACL, mailboxSession);
                        boolean isSubscribed = subscriptions.isSubscribed(messageManager.getMailboxPath());
                        MailboxId x$1 = id;
                        String x$2 = mailboxValidation.mailboxName();
                        Option x$3 = (Option)tuple2._1();
                        Option<Role> x$4 = role;
                        SortOrder x$5 = sortOrder;
                        UnreadEmails x$6 = mailboxValidation.unreadEmails();
                        TotalEmails x$7 = mailboxValidation.totalEmails();
                        UnreadThreads x$8 = mailboxValidation.unreadThreads();
                        TotalThreads x$9 = mailboxValidation.totalThreads();
                        MailboxRights x$10 = myRights;
                        MailboxNamespace x$11 = namespace;
                        Rights x$12 = rights;
                        Map<QuotaId, Quota> x$13 = ((Quotas)tuple2._2()).quotas();
                        boolean x$14 = isSubscribed;
                        return new Mailbox(x$1, x$2, (Option<MailboxId>)x$3, x$4, x$5, x$7, x$6, x$9, x$8, x$10, x$14, x$11, x$12, x$13);
                    });
                    break block4;
                }
                throw new MatchError(either);
            }
            catch (Exception error) {
                sMono = SMono$.MODULE$.error((Throwable)error);
            }
        }
        return sMono;
    }

    private SMono<Option<MailboxId>> getParentId(MessageManager messageManager, MailboxSession mailboxSession) {
        return (SMono)this.getParentPath(messageManager.getMailboxPath(), mailboxSession).map((Function1 & Serializable)parentPath -> SMono$.MODULE$.apply($this.mailboxManager.getMailboxReactive(parentPath, mailboxSession)).map((Function1 & Serializable)x$4 -> x$4.getId()).map((Function1 & Serializable)x$5 -> new Some(x$5)).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof MailboxNotFoundException) {
                return SMono$.MODULE$.just((Object)None$.MODULE$);
            }
            return SMono$.MODULE$.error(throwable);
        })).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)None$.MODULE$));
    }

    public static final /* synthetic */ Mailbox $anonfun$create$1(MailboxFactory $this, MailboxMetaData mailboxMetaData$1, MailboxSession mailboxSession$2, Map allMailboxesMetadata$1, Subscriptions subscriptions$1, MailboxValidation mailboxValidation$1, Map quotas) {
        MailboxId id = mailboxMetaData$1.getId();
        Option<Role> role = $this.getRole(mailboxMetaData$1.getPath(), mailboxSession$2);
        SortOrder sortOrder = $this.getSortOrder(role);
        Rights rights = $this.getRights(mailboxMetaData$1.getResolvedAcls());
        MailboxNamespace namespace = $this.getNamespace(mailboxMetaData$1.getPath(), mailboxSession$2);
        Option<MailboxPath> parentPath = $this.getParentPath(mailboxMetaData$1.getPath(), mailboxSession$2);
        Option parentId = parentPath.flatMap((Function1 & Serializable)path -> allMailboxesMetadata$1.get(path)).map((Function1 & Serializable)x$2 -> x$2.getId());
        MailboxRights myRights = $this.getMyRights(mailboxMetaData$1.getPath(), mailboxMetaData$1.getResolvedAcls(), mailboxSession$2);
        boolean isSubscribed = subscriptions$1.isSubscribed(mailboxMetaData$1);
        MailboxId x$1 = id;
        String x$22 = mailboxValidation$1.mailboxName();
        Option x$3 = parentId;
        Option<Role> x$4 = role;
        SortOrder x$5 = sortOrder;
        UnreadEmails x$6 = mailboxValidation$1.unreadEmails();
        TotalEmails x$7 = mailboxValidation$1.totalEmails();
        UnreadThreads x$8 = mailboxValidation$1.unreadThreads();
        TotalThreads x$9 = mailboxValidation$1.totalThreads();
        MailboxRights x$10 = myRights;
        MailboxNamespace x$11 = namespace;
        Rights x$12 = rights;
        Map x$13 = quotas;
        boolean x$14 = isSubscribed;
        return new Mailbox(x$1, x$22, (Option<MailboxId>)x$3, x$4, x$5, x$7, x$6, x$9, x$8, x$10, x$14, x$11, x$12, (Map<QuotaId, Quota>)x$13);
    }

    @Inject
    public MailboxFactory(MailboxManager mailboxManager, NamespaceFactory namespaceFactory, SortOrderProvider sortOrderProvider) {
        this.mailboxManager = mailboxManager;
        this.namespaceFactory = namespaceFactory;
        this.sortOrderProvider = sortOrderProvider;
    }
}

