/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.util.Matrix;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.AbstractPDF2XHTML;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.parser.pdf.image.ImageGraphicsEngine;
import org.apache.tika.renderer.PageRangeRequest;
import org.apache.tika.renderer.RenderResult;
import org.apache.tika.renderer.RenderResults;
import org.apache.tika.renderer.Renderer;
import org.apache.tika.renderer.pdf.pdfbox.PDFRenderingState;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class PDF2XHTML
extends AbstractPDF2XHTML {
    private Map<COSStream, Integer> processedInlineImages = new HashMap<COSStream, Integer>();
    private AtomicInteger inlineImageCounter = new AtomicInteger(0);

    PDF2XHTML(PDDocument document, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws IOException {
        super(document, handler, context, metadata, config);
    }

    public static void process(PDDocument document, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws SAXException, TikaException {
        PDF2XHTML pdf2XHTML = null;
        try {
            pdf2XHTML = config.isDetectAngles() ? new AngleDetectingPDF2XHTML(document, handler, context, metadata, config) : new PDF2XHTML(document, handler, context, metadata, config);
            config.configure(pdf2XHTML);
            pdf2XHTML.writeText(document, new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) {
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() {
                }
            });
        }
        catch (IOException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw new TikaException("Unable to extract PDF content", e);
        }
        if (pdf2XHTML.exceptions.size() > 0) {
            throw new TikaException("Unable to extract PDF content", (Throwable)pdf2XHTML.exceptions.get(0));
        }
    }

    @Override
    public void processPage(PDPage page) throws IOException {
        try {
            super.processPage(page);
        }
        catch (IOException e) {
            this.handleCatchableIOE(e);
            this.endPage(page);
        }
    }

    @Override
    protected void endPage(PDPage page) throws IOException {
        try {
            this.writeParagraphEnd();
            try {
                this.extractImages(page);
                this.renderPage(page);
            }
            catch (IOException e) {
                this.handleCatchableIOE(e);
            }
            super.endPage(page);
        }
        catch (SAXException e) {
            throw new IOException("Unable to end a page", e);
        }
        catch (IOException e) {
            this.handleCatchableIOE(e);
        }
    }

    private void renderPage(PDPage page) throws IOException {
        if (this.config.getImageStrategy() != PDFParserConfig.IMAGE_STRATEGY.RENDER_PAGES_AT_PAGE_END) {
            return;
        }
        PDFRenderingState state = this.context.get(PDFRenderingState.class);
        TikaInputStream tis = state.getTikaInputStream();
        Renderer renderer = this.config.getRenderer();
        PageRangeRequest request = new PageRangeRequest(this.getCurrentPageNo(), this.getCurrentPageNo());
        Metadata renderedMetadata = new Metadata();
        renderedMetadata.set(TikaCoreProperties.TYPE, PDFParser.MEDIA_TYPE.toString());
        try (RenderResults results = renderer.render(tis, renderedMetadata, this.context, request);){
            for (RenderResult result : results.getResults()) {
                if (result.getStatus() != RenderResult.STATUS.SUCCESS || !this.embeddedDocumentExtractor.shouldParseEmbedded(result.getMetadata())) continue;
                InputStream is = result.getInputStream();
                Throwable throwable = null;
                try {
                    this.embeddedDocumentExtractor.parseEmbedded(is, this.xhtml, result.getMetadata(), true);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleCatchableIOE(new IOExceptionWithCause(e));
        }
    }

    void extractImages(PDPage page) throws SAXException, IOException {
        if (!this.config.isExtractInlineImages() && !this.config.isExtractInlineImageMetadataOnly()) {
            return;
        }
        ImageGraphicsEngine engine = this.config.getImageGraphicsEngineFactory().newEngine(page, this.getCurrentPageNo(), this.embeddedDocumentExtractor, this.config, this.processedInlineImages, this.inlineImageCounter, this.xhtml, this.metadata, this.context);
        engine.run();
        List<IOException> engineExceptions = engine.getExceptions();
        if (engineExceptions.size() > 0) {
            IOException first = engineExceptions.remove(0);
            if (this.config.isCatchIntermediateIOExceptions()) {
                this.exceptions.addAll(engineExceptions);
            }
            throw first;
        }
    }

    @Override
    protected void writeParagraphStart() throws IOException {
        super.writeParagraphStart();
        try {
            this.xhtml.startElement("p");
        }
        catch (SAXException e) {
            throw new IOException("Unable to start a paragraph", e);
        }
    }

    @Override
    protected void writeParagraphEnd() throws IOException {
        super.writeParagraphEnd();
        try {
            this.xhtml.endElement("p");
        }
        catch (SAXException e) {
            throw new IOException("Unable to end a paragraph", e);
        }
    }

    @Override
    protected void writeString(String text) throws IOException {
        try {
            this.xhtml.characters(text);
        }
        catch (SAXException e) {
            throw new IOException("Unable to write a string: " + text, e);
        }
    }

    @Override
    protected void writeCharacters(TextPosition text) throws IOException {
        try {
            this.xhtml.characters(text.getUnicode());
        }
        catch (SAXException e) {
            throw new IOException("Unable to write a character: " + text.getUnicode(), e);
        }
    }

    @Override
    protected void writeWordSeparator() throws IOException {
        try {
            this.xhtml.characters(this.getWordSeparator());
        }
        catch (SAXException e) {
            throw new IOException("Unable to write a space character", e);
        }
    }

    @Override
    protected void writeLineSeparator() throws IOException {
        try {
            this.xhtml.newline();
        }
        catch (SAXException e) {
            throw new IOException("Unable to write a newline character", e);
        }
    }

    static class AngleCollector
    extends PDFTextStripper {
        Set<Integer> angles = new HashSet<Integer>();

        AngleCollector() throws IOException {
        }

        public Set<Integer> getAngles() {
            return this.angles;
        }

        @Override
        protected void processTextPosition(TextPosition text) {
            Matrix m = text.getTextMatrix();
            m.concatenate(text.getFont().getFontMatrix());
            int angle = (int)Math.round(Math.toDegrees(Math.atan2(m.getShearY(), m.getScaleY())));
            angle = (angle + 360) % 360;
            this.angles.add(angle);
        }
    }

    private static class AngleDetectingPDF2XHTML
    extends PDF2XHTML {
        private AngleDetectingPDF2XHTML(PDDocument document, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws IOException {
            super(document, handler, context, metadata, config);
        }

        @Override
        protected void startPage(PDPage page) throws IOException {
        }

        @Override
        protected void endPage(PDPage page) throws IOException {
        }

        @Override
        public void processPage(PDPage page) throws IOException {
            try {
                super.startPage(page);
                this.detectAnglesAndProcessPage(page);
            }
            catch (IOException e) {
                this.handleCatchableIOE(e);
            }
            finally {
                super.endPage(page);
            }
        }

        private void detectAnglesAndProcessPage(PDPage page) throws IOException {
            AngleCollector angleCollector = new AngleCollector();
            angleCollector.setStartPage(this.getCurrentPageNo());
            angleCollector.setEndPage(this.getCurrentPageNo());
            angleCollector.getText(this.document);
            int rotation = page.getRotation();
            page.setRotation(0);
            for (Integer angle : angleCollector.getAngles()) {
                if (angle == 0) {
                    try {
                        super.processPage(page);
                    }
                    catch (IOException e) {
                        this.handleCatchableIOE(e);
                    }
                    continue;
                }
                try (PDPageContentStream cs = new PDPageContentStream(this.document, page, PDPageContentStream.AppendMode.PREPEND, false);){
                    cs.transform(Matrix.getRotateInstance(-Math.toRadians(angle.intValue()), 0.0f, 0.0f));
                }
                try {
                    super.processPage(page);
                }
                catch (IOException e) {
                    this.handleCatchableIOE(e);
                }
                COSArray contents = (COSArray)page.getCOSObject().getItem(COSName.CONTENTS);
                contents.remove(0);
            }
            page.setRotation(rotation);
        }

        @Override
        protected void processTextPosition(TextPosition text) {
            Matrix m = text.getTextMatrix();
            m.concatenate(text.getFont().getFontMatrix());
            int angle = (int)Math.round(Math.toDegrees(Math.atan2(m.getShearY(), m.getScaleY())));
            if (angle == 0) {
                super.processTextPosition(text);
            }
        }
    }
}

