/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.core;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class ClearWorkspace
implements Command {
    private static Log log = LogFactory.getLog(ClearWorkspace.class);

    @Override
    public boolean execute(Context ctx) throws Exception {
        Session s = CommandHelper.getSession(ctx);
        if (log.isDebugEnabled()) {
            log.debug("removing all content from workspace " + s.getWorkspace().getName());
        }
        CommandHelper.setCurrentNode(ctx, s.getRootNode());
        NodeIterator iter = s.getRootNode().getNodes();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            if (n.getName().equals("jcr:system")) continue;
            n.remove();
        }
        PropertyIterator pIter = s.getRootNode().getProperties();
        while (pIter.hasNext()) {
            Property p = pIter.nextProperty();
            if (p.getName().equals("jcr:primaryType")) continue;
            p.remove();
        }
        return false;
    }
}

