/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.util.StateUtility;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeState
extends ItemState {
    private static Logger log = LoggerFactory.getLogger(NodeState.class);
    private Name nodeTypeName;
    private QNodeDefinition definition;
    private Name[] mixinTypeNames = Name.EMPTY_ARRAY;

    protected NodeState(NodeEntry entry, Name nodeTypeName, Name[] mixinTypeNames, ItemStateFactory isf, QNodeDefinition definition, ItemDefinitionProvider definitionProvider) {
        super(4, entry, isf, definitionProvider);
        this.nodeTypeName = nodeTypeName;
        this.setMixinTypeNames(mixinTypeNames);
        this.definition = definition;
    }

    protected NodeState(NodeEntry entry, NodeInfo nInfo, ItemStateFactory isf, ItemDefinitionProvider definitionProvider) {
        super(entry, isf, definitionProvider);
        this.nodeTypeName = nInfo.getNodetype();
        this.setMixinTypeNames(nInfo.getMixins());
    }

    @Override
    public final boolean isNode() {
        return true;
    }

    @Override
    public ItemId getId() throws RepositoryException {
        return this.getNodeId();
    }

    @Override
    public ItemId getWorkspaceId() throws RepositoryException {
        return this.getNodeEntry().getWorkspaceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemState.MergeResult merge(ItemState another, boolean keepChanges) {
        boolean modified = false;
        if (another != null && another != this) {
            if (!another.isNode()) {
                throw new IllegalArgumentException("Attempt to merge node state with property state.");
            }
            ItemState itemState = another;
            synchronized (itemState) {
                List<Name> mixN;
                NodeState nState = (NodeState)another;
                if (!this.nodeTypeName.equals(nState.nodeTypeName)) {
                    this.nodeTypeName = nState.nodeTypeName;
                    modified = true;
                }
                if (nState.definition != null && !nState.definition.equals(this.definition)) {
                    this.definition = nState.definition;
                    modified = true;
                }
                if ((mixN = Arrays.asList(nState.mixinTypeNames)).size() != this.mixinTypeNames.length || !mixN.containsAll(Arrays.asList(this.mixinTypeNames))) {
                    this.setMixinTypeNames(nState.mixinTypeNames);
                    modified = true;
                }
            }
        }
        return new ItemState.SimpleMergeResult(modified);
    }

    @Override
    public boolean revert() {
        if (StateUtility.isMovedState(this)) {
            try {
                QNodeDefinition def = this.retrieveDefinition();
                if (!def.equals(this.definition)) {
                    this.definition = def;
                    return true;
                }
            }
            catch (RepositoryException e) {
                log.warn("Internal error", e);
            }
        }
        return false;
    }

    public NodeEntry getNodeEntry() {
        return (NodeEntry)this.getHierarchyEntry();
    }

    public NodeId getNodeId() throws RepositoryException {
        return this.getNodeEntry().getId();
    }

    public String getUniqueID() {
        return this.getNodeEntry().getUniqueID();
    }

    public boolean isRoot() {
        return this.getHierarchyEntry().getParent() == null;
    }

    public Name getNodeTypeName() {
        return this.nodeTypeName;
    }

    public Name[] getMixinTypeNames() {
        return this.mixinTypeNames;
    }

    public void setMixinTypeNames(Name[] mixinTypeNames) {
        if (mixinTypeNames != null) {
            this.mixinTypeNames = mixinTypeNames;
        }
    }

    public synchronized Name[] getNodeTypeNames() {
        Name[] mixinNames = this.getMixinTypeNames();
        Name[] types = new Name[mixinNames.length + 1];
        System.arraycopy(mixinNames, 0, types, 0, mixinNames.length);
        types[types.length - 1] = this.getNodeTypeName();
        return types;
    }

    public synchronized Name[] getAllNodeTypeNames() {
        Name[] allNtNames;
        if (this.getStatus() == 1) {
            allNtNames = this.getNodeTypeNames();
        } else {
            Name primaryType = this.getNodeTypeName();
            allNtNames = new Name[]{primaryType};
            try {
                PropertyEntry pe = this.getNodeEntry().getPropertyEntry(NameConstants.JCR_MIXINTYPES, true);
                if (pe != null) {
                    PropertyState mixins = pe.getPropertyState();
                    QValue[] values = mixins.getValues();
                    allNtNames = new Name[values.length + 1];
                    for (int i = 0; i < values.length; ++i) {
                        allNtNames[i] = values[i].getName();
                    }
                    allNtNames[values.length] = primaryType;
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return allNtNames;
    }

    public boolean hasDefinition() throws RepositoryException {
        return this.definition != null;
    }

    public QNodeDefinition getDefinition() throws RepositoryException {
        if (this.definition == null) {
            this.definition = this.retrieveDefinition();
        }
        return this.definition;
    }

    public Iterator<PropertyId> getNodeReferences(Name propertyName, boolean weak) {
        return this.isf.getNodeReferences(this, propertyName, weak);
    }

    public boolean hasChildNodeEntry(Name name, int index) {
        return this.getNodeEntry().hasNodeEntry(name, index);
    }

    public NodeState getChildNodeState(Name nodeName, int index) throws ItemNotFoundException, RepositoryException {
        NodeEntry ne = this.getNodeEntry().getNodeEntry(nodeName, index, true);
        if (ne != null) {
            return ne.getNodeState();
        }
        throw new ItemNotFoundException("Child node " + String.valueOf(nodeName) + " with index " + index + " does not exist.");
    }

    public boolean hasPropertyName(Name propName) {
        return this.getNodeEntry().hasPropertyEntry(propName);
    }

    public PropertyState getPropertyState(Name propertyName) throws ItemNotFoundException, RepositoryException {
        PropertyEntry pe = this.getNodeEntry().getPropertyEntry(propertyName, true);
        if (pe != null) {
            return pe.getPropertyState();
        }
        throw new ItemNotFoundException("Child Property with name " + String.valueOf(propertyName) + " does not exist.");
    }

    synchronized void reorderChildNodeEntries(NodeState insertNode, NodeState beforeNode) throws ItemNotFoundException, RepositoryException {
        NodeEntry before = beforeNode == null ? null : beforeNode.getNodeEntry();
        insertNode.getNodeEntry().orderBefore(before);
        this.markModified();
    }

    synchronized void moveChildNodeEntry(NodeState newParent, NodeState childState, Name newName, QNodeDefinition newDefinition) throws RepositoryException {
        childState.getNodeEntry().move(newName, newParent.getNodeEntry(), true);
        childState.definition = newDefinition;
        this.markModified();
        newParent.markModified();
        childState.markModified();
    }

    private QNodeDefinition retrieveDefinition() throws RepositoryException {
        QNodeDefinition def;
        if (this.isRoot()) {
            def = this.definitionProvider.getRootNodeDefinition();
        } else {
            NodeState parent = this.getParent();
            NodeId wspId = (NodeId)this.getWorkspaceId();
            def = this.definitionProvider.getQNodeDefinition(parent.getNodeTypeNames(), this.getName(), this.getNodeTypeName(), wspId);
        }
        return def;
    }
}

