/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import java.util.ArrayList;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFZScore
implements UDTF {
    ArrayList<Double> value = new ArrayList();
    ArrayList<Long> timestamp = new ArrayList();
    static final String BATCH_COMPUTE = "batch";
    static final String STREAM_COMPUTE = "stream";
    String compute = "batch";
    double avg = 0.0;
    double sd = 0.0;
    double sum = 0.0;
    double squareSum = 0.0;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.FLOAT, Type.DOUBLE, Type.INT32, Type.INT64).validate(x -> ((String)x).equalsIgnoreCase(BATCH_COMPUTE) || ((String)x).equalsIgnoreCase(STREAM_COMPUTE), "Parameter \"compute\" is illegal. Please use \"batch\" (for default) or \"stream\".", (Object)validator.getParameters().getStringOrDefault("compute", BATCH_COMPUTE)).validate(x -> (Double)x > 0.0, "Parameter \"sd\" is illegal. It should be larger than 0.", (Object)validator.getParameters().getDoubleOrDefault("sd", 1.0));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        this.value.clear();
        this.timestamp.clear();
        this.sum = 0.0;
        this.squareSum = 0.0;
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.compute = parameters.getStringOrDefault("compute", BATCH_COMPUTE);
        if (this.compute.equalsIgnoreCase(STREAM_COMPUTE)) {
            this.avg = parameters.getDouble("avg");
            this.sd = parameters.getDouble("sd");
        }
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        double v;
        if (this.compute.equalsIgnoreCase(STREAM_COMPUTE) && this.sd > 0.0) {
            collector.putDouble(row.getTime(), (Util.getValueAsDouble(row) - this.avg) / this.sd);
        } else if (this.compute.equalsIgnoreCase(BATCH_COMPUTE) && Double.isFinite(v = Util.getValueAsDouble(row))) {
            this.value.add(v);
            this.timestamp.add(row.getTime());
            this.sum += v;
            this.squareSum += v * v;
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        if (this.compute.equalsIgnoreCase(BATCH_COMPUTE)) {
            this.avg = this.sum / (double)this.value.size();
            this.sd = Math.sqrt(this.squareSum / (double)this.value.size() - this.avg * this.avg);
            for (int i = 0; i < this.value.size(); ++i) {
                collector.putDouble(this.timestamp.get(i), (this.value.get(i) - this.avg) / this.sd);
            }
        }
    }
}

