/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.receiver;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.receiver.IoTDBReceiver;
import org.apache.iotdb.commons.pipe.receiver.IoTDBReceiverAgent;
import org.apache.iotdb.commons.pipe.resource.log.PipeLogger;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.IoTDBSinkRequestVersion;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeTransferFilePieceReq;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeTransferFileSealReqV1;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeTransferFileSealReqV2;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeTransferHandshakeV1Req;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeTransferHandshakeV2Req;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.response.PipeTransferFilePieceResp;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IoTDBFileReceiver
implements IoTDBReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBFileReceiver.class);
    protected final AtomicReference<File> receiverFileDirWithIdSuffix = new AtomicReference();
    private static final AtomicLong RECEIVER_ID_GENERATOR = new AtomicLong(0L);
    protected final AtomicLong receiverId = new AtomicLong(0L);
    private String originalThreadName;
    protected String username = "root";
    protected String password = "root";
    private static final long LOGIN_PERIODIC_VERIFICATION_INTERVAL_MS = PipeConfig.getInstance().getPipeReceiverLoginPeriodicVerificationIntervalMs();
    protected long lastSuccessfulLoginTime = Long.MIN_VALUE;
    private File writingFile;
    private RandomAccessFile writingFileWriter;
    protected boolean shouldConvertDataTypeOnTypeMismatch = true;
    protected final AtomicBoolean isUsingAsyncLoadTsFileStrategy = new AtomicBoolean(false);
    protected final AtomicBoolean validateTsFile = new AtomicBoolean(true);
    protected final AtomicBoolean shouldMarkAsPipeRequest = new AtomicBoolean(true);

    @Override
    public IoTDBSinkRequestVersion getVersion() {
        return IoTDBSinkRequestVersion.VERSION_1;
    }

    protected TPipeTransferResp handleTransferHandshakeV1(PipeTransferHandshakeV1Req req) {
        String receiverFileBaseDir;
        if (!CommonDescriptor.getInstance().getConfig().getTimestampPrecision().equals(req.getTimestampPrecision())) {
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_HANDSHAKE_ERROR, (String)String.format("IoTDB receiver's timestamp precision %s, connector's timestamp precision %s. Validation fails.", CommonDescriptor.getInstance().getConfig().getTimestampPrecision(), req.getTimestampPrecision()));
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Handshake failed, response status = %s.", status);
            return new TPipeTransferResp(status);
        }
        if (this.originalThreadName == null) {
            this.originalThreadName = Thread.currentThread().getName();
        }
        this.receiverId.set(RECEIVER_ID_GENERATOR.incrementAndGet());
        Thread.currentThread().setName(String.format("Pipe-Receiver-%s-%s:%s", this.receiverId.get(), this.getSenderHost(), this.getSenderPort()));
        if (this.receiverFileDirWithIdSuffix.get() != null) {
            if (this.receiverFileDirWithIdSuffix.get().exists()) {
                try {
                    RetryUtils.retryOnException(() -> {
                        FileUtils.deleteDirectory((File)this.receiverFileDirWithIdSuffix.get());
                        return null;
                    });
                    LOGGER.info("Receiver id = {}: Original receiver file dir {} was deleted.", (Object)this.receiverId.get(), (Object)this.receiverFileDirWithIdSuffix.get().getPath());
                }
                catch (Exception e) {
                    PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Failed to delete original receiver file dir %s, because %s.", this.receiverId.get(), this.receiverFileDirWithIdSuffix.get().getPath(), e.getMessage(), e);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Receiver id = {}: Original receiver file dir {} is not existed. No need to delete.", (Object)this.receiverId.get(), (Object)this.receiverFileDirWithIdSuffix.get().getPath());
            }
            this.receiverFileDirWithIdSuffix.set(null);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Receiver id = {}: Current receiver file dir is null. No need to delete.", (Object)this.receiverId.get());
        }
        try {
            receiverFileBaseDir = this.getReceiverFileBaseDir();
            if (Objects.isNull(receiverFileBaseDir)) {
                PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Failed to init pipe receiver file folder manager because all disks of folders are full.", this.receiverId.get());
                return new TPipeTransferResp(StatusUtils.getStatus(TSStatusCode.DISK_SPACE_INSUFFICIENT));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Receiver id = {}: Failed to create pipe receiver file folder because all disks of folders are full.", (Object)this.receiverId.get(), (Object)e);
            return new TPipeTransferResp(StatusUtils.getStatus(TSStatusCode.DISK_SPACE_INSUFFICIENT));
        }
        File newReceiverDir = new File(receiverFileBaseDir, Long.toString(this.receiverId.get()));
        if (!newReceiverDir.exists() && !newReceiverDir.mkdirs()) {
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = {}: Failed to create receiver file dir {}.", this.receiverId.get(), newReceiverDir.getPath());
            return new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_HANDSHAKE_ERROR, (String)String.format("Failed to create receiver file dir %s.", newReceiverDir.getPath())));
        }
        this.receiverFileDirWithIdSuffix.set(newReceiverDir);
        LOGGER.info("Receiver id = {}: Handshake successfully! Sender's host = {}, port = {}. Receiver's file dir = {}.", new Object[]{this.receiverId.get(), this.getSenderHost(), this.getSenderPort(), newReceiverDir.getPath()});
        return new TPipeTransferResp(RpcUtils.SUCCESS_STATUS);
    }

    protected abstract String getReceiverFileBaseDir() throws Exception;

    protected abstract String getSenderHost();

    protected abstract String getSenderPort();

    protected TPipeTransferResp handleTransferHandshakeV2(PipeTransferHandshakeV2Req req) throws IOException {
        String loadTsFileStrategyString;
        String passwordString;
        String clusterIdFromConfigNode = this.getClusterId();
        if (clusterIdFromConfigNode == null) {
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_HANDSHAKE_ERROR, (String)"Receiver can not get clusterId from config node.");
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Handshake failed, response status = %s.", this.receiverId.get(), status);
            return new TPipeTransferResp(status);
        }
        String clusterIdFromHandshakeRequest = req.getParams().get("clusterID");
        if (clusterIdFromHandshakeRequest == null) {
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_HANDSHAKE_ERROR, (String)"Handshake request does not contain clusterId.");
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Handshake failed, response status = %s.", this.receiverId.get(), status);
            return new TPipeTransferResp(status);
        }
        if (Objects.equals(clusterIdFromConfigNode, clusterIdFromHandshakeRequest)) {
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_HANDSHAKE_ERROR, (String)String.format("Receiver and sender are from the same cluster %s.", clusterIdFromHandshakeRequest));
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Handshake failed, response status = %s.", this.receiverId.get(), status);
            return new TPipeTransferResp(status);
        }
        String timestampPrecision = req.getParams().get("timestampPrecision");
        if (timestampPrecision == null) {
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_HANDSHAKE_ERROR, (String)"Handshake request does not contain timestampPrecision.");
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Handshake failed, response status = %s.", this.receiverId.get(), status);
            return new TPipeTransferResp(status);
        }
        String usernameString = req.getParams().get("username");
        if (usernameString != null) {
            this.username = usernameString;
        }
        if ((passwordString = req.getParams().get("password")) != null) {
            this.password = passwordString;
        }
        TSStatus status = this.loginIfNecessary();
        if (status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Handshake failed because login failed, response status = %s.", this.receiverId.get(), status);
            return new TPipeTransferResp(status);
        }
        LOGGER.info("Receiver id = {}: User {} login successfully.", (Object)this.receiverId.get(), (Object)this.username);
        String shouldConvertDataTypeOnTypeMismatchString = req.getParams().get("convertOnTypeMismatch");
        if (shouldConvertDataTypeOnTypeMismatchString != null) {
            this.shouldConvertDataTypeOnTypeMismatch = Boolean.parseBoolean(shouldConvertDataTypeOnTypeMismatchString);
        }
        if ((loadTsFileStrategyString = req.getParams().get("loadTsFileStrategy")) != null) {
            this.isUsingAsyncLoadTsFileStrategy.set(Objects.equals("async", loadTsFileStrategyString));
        }
        this.validateTsFile.set(Boolean.parseBoolean(req.getParams().getOrDefault("validateTsFile", "true")));
        this.shouldMarkAsPipeRequest.set(Boolean.parseBoolean(req.getParams().getOrDefault("markAsPipeRequest", "true")));
        return this.handleTransferHandshakeV1(new PipeTransferHandshakeV1Req(){

            @Override
            protected PipeRequestType getPlanType() {
                return PipeRequestType.HANDSHAKE_DATANODE_V1;
            }
        }.convertToTPipeTransferReq(timestampPrecision));
    }

    protected abstract String getClusterId();

    protected boolean shouldLogin() {
        return LOGIN_PERIODIC_VERIFICATION_INTERVAL_MS >= 0L && this.lastSuccessfulLoginTime < System.currentTimeMillis() - LOGIN_PERIODIC_VERIFICATION_INTERVAL_MS;
    }

    protected TSStatus loginIfNecessary() {
        if (this.shouldLogin()) {
            TSStatus permissionCheckStatus = this.login();
            if (permissionCheckStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Failed to login, username = %s, response = %s.", this.receiverId.get(), this.username, permissionCheckStatus);
                return permissionCheckStatus;
            }
            this.lastSuccessfulLoginTime = System.currentTimeMillis();
        }
        return StatusUtils.OK;
    }

    protected abstract TSStatus login();

    protected final TPipeTransferResp handleTransferFilePiece(PipeTransferFilePieceReq req, boolean isRequestThroughAirGap, boolean isSingleFile) {
        try {
            this.updateWritingFileIfNeeded(req.getFileName(), isSingleFile);
            if (isRequestThroughAirGap && req.getStartWritingOffset() < this.writingFileWriter.length()) {
                this.writingFileWriter.setLength(req.getStartWritingOffset());
            }
            if (!this.isWritingFileOffsetCorrect(req.getStartWritingOffset())) {
                if (!this.writingFile.getName().endsWith(".tsfile")) {
                    this.writingFileWriter.setLength(0L);
                }
                TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_OFFSET_RESET, (String)String.format("Request sender to reset file reader's offset from %s to %s.", req.getStartWritingOffset(), this.writingFileWriter.length()));
                PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: File offset reset requested by receiver, response status = %s.", this.receiverId.get(), status);
                return PipeTransferFilePieceResp.toTPipeTransferResp(status, this.writingFileWriter.length());
            }
            this.writingFileWriter.write(req.getFilePiece());
            return PipeTransferFilePieceResp.toTPipeTransferResp(RpcUtils.SUCCESS_STATUS, this.writingFileWriter.length());
        }
        catch (Exception e) {
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), e, "Receiver id = %s: Failed to write file piece from req %s.", new Object[]{this.receiverId.get(), req});
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_ERROR, (String)String.format("Failed to write file piece, because %s", e.getMessage()));
            try {
                return PipeTransferFilePieceResp.toTPipeTransferResp(status, -1L);
            }
            catch (Exception ex) {
                return PipeTransferFilePieceResp.toTPipeTransferResp(status);
            }
        }
    }

    protected final void updateWritingFileIfNeeded(String fileName, boolean isSingleFile) throws IOException {
        if (this.isFileExistedAndNameCorrect(fileName)) {
            return;
        }
        LOGGER.info("Receiver id = {}: Writing file {} is not existed or name is not correct, try to create it. Current writing file is {}.", new Object[]{this.receiverId.get(), fileName, this.writingFile == null ? "null" : this.writingFile.getPath()});
        this.closeCurrentWritingFileWriter(!isSingleFile);
        if (this.writingFile != null && isSingleFile) {
            this.deleteCurrentWritingFile();
        }
        if (!this.receiverFileDirWithIdSuffix.get().exists()) {
            if (this.receiverFileDirWithIdSuffix.get().mkdirs()) {
                LOGGER.info("Receiver id = {}: Receiver file dir {} was created.", (Object)this.receiverId.get(), (Object)this.receiverFileDirWithIdSuffix.get().getPath());
            } else {
                LOGGER.error("Receiver id = {}: Failed to create receiver file dir {}.", (Object)this.receiverId.get(), (Object)this.receiverFileDirWithIdSuffix.get().getPath());
            }
        }
        this.writingFile = new File(this.receiverFileDirWithIdSuffix.get(), fileName);
        this.writingFileWriter = new RandomAccessFile(this.writingFile, "rw");
        LOGGER.info("Receiver id = {}: Writing file {} was created. Ready to write file pieces.", (Object)this.receiverId.get(), (Object)this.writingFile.getPath());
    }

    private boolean isFileExistedAndNameCorrect(String fileName) {
        return this.writingFile != null && this.writingFile.exists() && this.writingFile.getName().equals(fileName);
    }

    private void closeCurrentWritingFileWriter(boolean fsyncAfterClose) {
        if (this.writingFileWriter != null) {
            try {
                if (PipeConfig.getInstance().getPipeFileReceiverFsyncEnabled() && fsyncAfterClose) {
                    this.writingFileWriter.getFD().sync();
                }
                this.writingFileWriter.close();
                LOGGER.info("Receiver id = {}: Current writing file writer {} was closed.", (Object)this.receiverId.get(), (Object)(this.writingFile == null ? "null" : this.writingFile.getPath()));
            }
            catch (Exception e) {
                PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Failed to close current writing file writer %s, because %s.", this.receiverId.get(), this.writingFile == null ? "null" : this.writingFile.getPath(), e.getMessage(), e);
            }
            this.writingFileWriter = null;
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Receiver id = {}: Current writing file writer is null. No need to close.", (Object)this.receiverId.get());
        }
    }

    private void deleteCurrentWritingFile() {
        if (this.writingFile != null) {
            this.deleteFile(this.writingFile);
            this.writingFile = null;
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Receiver id = {}: Current writing file is null. No need to delete.", (Object)this.receiverId.get());
        }
    }

    private void deleteFile(File file) {
        if (file.exists()) {
            try {
                RetryUtils.retryOnException(() -> FileUtils.delete((File)file));
                LOGGER.info("Receiver id = {}: Original writing file {} was deleted.", (Object)this.receiverId.get(), (Object)file.getPath());
            }
            catch (Exception e) {
                PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Failed to delete original writing file %s, because %s.", this.receiverId.get(), file.getPath(), e.getMessage(), e);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Receiver id = {}: Original file {} is not existed. No need to delete.", (Object)this.receiverId.get(), (Object)file.getPath());
        }
    }

    private boolean isWritingFileOffsetCorrect(long offset) throws IOException {
        boolean offsetCorrect;
        boolean bl = offsetCorrect = this.writingFileWriter.length() == offset;
        if (!offsetCorrect) {
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Writing file %s's offset is %s, but request sender's offset is %s.", this.receiverId.get(), this.writingFile.getPath(), this.writingFileWriter.length(), offset);
        }
        return offsetCorrect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final TPipeTransferResp handleTransferFileSealV1(PipeTransferFileSealReqV1 req) {
        try {
            if (!this.isWritingFileAvailable()) {
                TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file, because writing file %s is not available.", this.writingFile));
                PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), status.getMessage(), new Object[0]);
                TPipeTransferResp tPipeTransferResp = new TPipeTransferResp(status);
                return tPipeTransferResp;
            }
            TPipeTransferResp resp = this.checkFinalFileSeal(req.getFileName(), req.getFileLength());
            if (Objects.nonNull(resp)) {
                TPipeTransferResp tPipeTransferResp = resp;
                return tPipeTransferResp;
            }
            String fileAbsolutePath = this.writingFile.getAbsolutePath();
            if (PipeConfig.getInstance().getPipeFileReceiverFsyncEnabled()) {
                this.writingFileWriter.getFD().sync();
            }
            this.writingFileWriter.close();
            this.writingFileWriter = null;
            this.writingFile = null;
            TSStatus status = this.loadFileV1(req, fileAbsolutePath);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.info("Receiver id = {}: Seal file {} successfully.", (Object)this.receiverId.get(), (Object)fileAbsolutePath);
            } else {
                PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Failed to seal file %s, because %s.", this.receiverId.get(), fileAbsolutePath, status.getMessage());
            }
            TPipeTransferResp tPipeTransferResp = new TPipeTransferResp(status);
            return tPipeTransferResp;
        }
        catch (Exception e) {
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Failed to seal file %s from req %s.", new Object[]{this.receiverId.get(), this.writingFile, req, e});
            TPipeTransferResp tPipeTransferResp = new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s because %s", this.writingFile, e.getMessage())));
            return tPipeTransferResp;
        }
        finally {
            this.closeCurrentWritingFileWriter(false);
            this.deleteCurrentWritingFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final TPipeTransferResp handleTransferFileSealV2(PipeTransferFileSealReqV2 req) {
        List files = req.getFileNames().stream().map(fileName -> new File(this.receiverFileDirWithIdSuffix.get(), (String)fileName)).collect(Collectors.toList());
        try {
            if (!this.isWritingFileAvailable()) {
                TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s, because writing file %s is not available.", req.getFileNames(), this.writingFile));
                PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), status.getMessage(), new Object[0]);
                TPipeTransferResp tPipeTransferResp = new TPipeTransferResp(status);
                return tPipeTransferResp;
            }
            for (int i = 0; i < req.getFileNames().size(); ++i) {
                TPipeTransferResp resp;
                TPipeTransferResp tPipeTransferResp = resp = i == req.getFileNames().size() - 1 ? this.checkFinalFileSeal(req.getFileNames().get(i), req.getFileLengths().get(i)) : this.checkNonFinalFileSeal((File)files.get(i), req.getFileNames().get(i), req.getFileLengths().get(i));
                if (!Objects.nonNull(resp)) continue;
                TPipeTransferResp tPipeTransferResp2 = resp;
                return tPipeTransferResp2;
            }
            if (PipeConfig.getInstance().getPipeFileReceiverFsyncEnabled()) {
                this.writingFileWriter.getFD().sync();
            }
            this.writingFileWriter.close();
            this.writingFileWriter = null;
            this.writingFile = null;
            List<String> fileAbsolutePaths = files.stream().map(File::getAbsolutePath).collect(Collectors.toList());
            TSStatus status = this.loadFileV2(req, fileAbsolutePaths);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.info("Receiver id = {}: Seal file {} successfully.", (Object)this.receiverId.get(), fileAbsolutePaths);
            } else {
                PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Failed to seal file %s, status is %s.", this.receiverId.get(), fileAbsolutePaths, status);
            }
            TPipeTransferResp tPipeTransferResp = new TPipeTransferResp(status);
            return tPipeTransferResp;
        }
        catch (Exception e) {
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Failed to seal file %s from req %s.", new Object[]{this.receiverId.get(), files, req, e});
            TPipeTransferResp tPipeTransferResp = new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s because %s", this.writingFile, e.getMessage())));
            return tPipeTransferResp;
        }
        finally {
            this.closeCurrentWritingFileWriter(false);
            IoTDBReceiverAgent.cleanPipeReceiverDir(this.receiverFileDirWithIdSuffix.get());
        }
    }

    private TPipeTransferResp checkNonFinalFileSeal(File file, String fileName, long fileLength) throws IOException {
        if (!file.exists()) {
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s, the file does not exist.", fileName));
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Failed to seal file %s, because the file does not exist.", this.receiverId.get(), fileName);
            return new TPipeTransferResp(status);
        }
        if (fileLength != file.length()) {
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s, because the length of file is not correct. The original file has length %s, but receiver file has length %s.", fileName, fileLength, this.writingFileWriter.length()));
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Failed to seal file %s, because the length of file is not correct. The original file has length %s, but receiver file has length %s.", this.receiverId.get(), fileName, fileLength, this.writingFileWriter.length());
            return new TPipeTransferResp(status);
        }
        return null;
    }

    private TPipeTransferResp checkFinalFileSeal(String fileName, long fileLength) throws IOException {
        if (!this.isFileExistedAndNameCorrect(fileName)) {
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s, because writing file is %s.", fileName, this.writingFile));
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Failed to seal file %s, because writing file is %s.", this.receiverId.get(), fileName, this.writingFile);
            return new TPipeTransferResp(status);
        }
        if (!this.isWritingFileOffsetCorrect(fileLength)) {
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s, because the length of file is not correct. The original file has length %s, but receiver file has length %s.", fileName, fileLength, this.writingFileWriter.length()));
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "Receiver id = %s: Failed to seal file %s, because the length of file is not correct. The original file has length %s, but receiver file has length %s.", this.receiverId.get(), fileName, fileLength, this.writingFileWriter.length());
            return new TPipeTransferResp(status);
        }
        return null;
    }

    private boolean isWritingFileAvailable() {
        boolean isWritingFileAvailable;
        boolean bl = isWritingFileAvailable = this.writingFile != null && this.writingFile.exists() && this.writingFileWriter != null;
        if (!isWritingFileAvailable) {
            LOGGER.info("Receiver id = {}: Writing file {} is not available. Writing file is null: {}, writing file exists: {}, writing file writer is null: {}.", new Object[]{this.receiverId.get(), this.writingFile, this.writingFile == null, this.writingFile != null && this.writingFile.exists(), this.writingFileWriter == null});
        }
        return isWritingFileAvailable;
    }

    protected abstract TSStatus loadFileV1(PipeTransferFileSealReqV1 var1, String var2) throws IOException;

    protected abstract TSStatus loadFileV2(PipeTransferFileSealReqV2 var1, List<String> var2) throws IOException, IllegalPathException;

    @Override
    public synchronized void handleExit() {
        if (this.writingFileWriter != null) {
            try {
                this.writingFileWriter.close();
                LOGGER.info("Receiver id = {}: Handling exit: Writing file writer was closed.", (Object)this.receiverId.get());
            }
            catch (Exception e) {
                LOGGER.warn("Receiver id = {}: Handling exit: Close writing file writer error.", (Object)this.receiverId.get(), (Object)e);
            }
            this.writingFileWriter = null;
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Receiver id = {}: Handling exit: Writing file writer is null. No need to close.", (Object)this.receiverId.get());
        }
        if (this.writingFile != null) {
            try {
                RetryUtils.retryOnException(() -> FileUtils.delete((File)this.writingFile));
                LOGGER.info("Receiver id = {}: Handling exit: Writing file {} was deleted.", (Object)this.receiverId.get(), (Object)this.writingFile.getPath());
            }
            catch (Exception e) {
                LOGGER.warn("Receiver id = {}: Handling exit: Delete writing file {} error.", new Object[]{this.receiverId.get(), this.writingFile.getPath(), e});
            }
            this.writingFile = null;
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Receiver id = {}: Handling exit: Writing file is null. No need to delete.", (Object)this.receiverId.get());
        }
        if (this.receiverFileDirWithIdSuffix.get() != null) {
            if (this.receiverFileDirWithIdSuffix.get().exists()) {
                try {
                    RetryUtils.retryOnException(() -> {
                        FileUtils.deleteDirectory((File)this.receiverFileDirWithIdSuffix.get());
                        return null;
                    });
                    LOGGER.info("Receiver id = {}: Handling exit: Original receiver file dir {} was deleted.", (Object)this.receiverId.get(), (Object)this.receiverFileDirWithIdSuffix.get().getPath());
                }
                catch (Exception e) {
                    LOGGER.warn("Receiver id = {}: Handling exit: Delete original receiver file dir {} error.", new Object[]{this.receiverId.get(), this.receiverFileDirWithIdSuffix.get().getPath(), e});
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Receiver id = {}: Handling exit: Original receiver file dir {} does not exist. No need to delete.", (Object)this.receiverId.get(), (Object)this.receiverFileDirWithIdSuffix.get().getPath());
            }
            this.receiverFileDirWithIdSuffix.set(null);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Receiver id = {}: Handling exit: Original receiver file dir is null. No need to delete.", (Object)this.receiverId.get());
        }
        this.closeSession();
        LOGGER.info("Receiver id = {}: Handling exit: Receiver exited.", (Object)this.receiverId.get());
        if (this.originalThreadName != null) {
            Thread.currentThread().setName(this.originalThreadName);
        }
    }

    protected abstract void closeSession();
}

