/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.credentials.connection;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import org.apache.polaris.core.connection.AuthenticationType;
import org.apache.polaris.core.connection.BearerAuthenticationParametersDpo;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.credentials.connection.CatalogAccessProperty;
import org.apache.polaris.core.credentials.connection.ConnectionCredentialVendor;
import org.apache.polaris.core.credentials.connection.ConnectionCredentials;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.service.credentials.connection.AuthType;

@RequestScoped
@AuthType(value=AuthenticationType.BEARER)
@Priority(value=100)
public class BearerConnectionCredentialVendor
implements ConnectionCredentialVendor {
    private final UserSecretsManager secretsManager;

    @Inject
    public BearerConnectionCredentialVendor(UserSecretsManager secretsManager) {
        this.secretsManager = secretsManager;
    }

    @Nonnull
    public ConnectionCredentials getConnectionCredentials(@Nonnull ConnectionConfigInfoDpo connectionConfig) {
        Preconditions.checkArgument((boolean)(connectionConfig.getAuthenticationParameters() instanceof BearerAuthenticationParametersDpo), (String)"Expected BearerAuthenticationParametersDpo, got: %s", (Object)connectionConfig.getAuthenticationParameters().getClass().getName());
        BearerAuthenticationParametersDpo bearerParams = (BearerAuthenticationParametersDpo)connectionConfig.getAuthenticationParameters();
        String bearerToken = this.secretsManager.readSecret(bearerParams.getBearerTokenReference());
        return ConnectionCredentials.builder().put(CatalogAccessProperty.BEARER_TOKEN, bearerToken).put(CatalogAccessProperty.EXPIRES_AT_MS, String.valueOf(Long.MAX_VALUE)).build();
    }
}

