/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.io;

import jakarta.annotation.Nonnull;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.Set;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.storage.PolarisStorageActions;
import org.apache.polaris.core.storage.StorageAccessConfig;
import org.apache.polaris.core.storage.StorageCredentialsVendor;
import org.apache.polaris.core.storage.cache.StorageCredentialCache;
import org.apache.polaris.service.catalog.io.FileIOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class StorageAccessConfigProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageAccessConfigProvider.class);
    private final StorageCredentialCache storageCredentialCache;
    private final StorageCredentialsVendor storageCredentialsVendor;

    @Inject
    public StorageAccessConfigProvider(StorageCredentialCache storageCredentialCache, StorageCredentialsVendor storageCredentialsVendor) {
        this.storageCredentialCache = storageCredentialCache;
        this.storageCredentialsVendor = storageCredentialsVendor;
    }

    public StorageAccessConfig getStorageAccessConfig(@Nonnull TableIdentifier tableIdentifier, @Nonnull Set<String> tableLocations, @Nonnull Set<PolarisStorageActions> storageActions, @Nonnull Optional<String> refreshCredentialsEndpoint, @Nonnull PolarisResolvedPathWrapper resolvedPath) {
        LOGGER.atDebug().addKeyValue("tableIdentifier", (Object)tableIdentifier).addKeyValue("tableLocation", tableLocations).log("Fetching client credentials for table");
        Optional<PolarisEntity> storageInfo = FileIOUtil.findStorageInfoFromHierarchy(resolvedPath);
        if (storageInfo.isEmpty()) {
            LOGGER.atWarn().addKeyValue("tableIdentifier", (Object)tableIdentifier).log("Table entity has no storage configuration in its hierarchy");
            return StorageAccessConfig.builder().supportsCredentialVending(false).build();
        }
        PolarisEntity storageInfoEntity = storageInfo.get();
        boolean skipCredentialSubscopingIndirection = (Boolean)this.storageCredentialsVendor.getRealmConfig().getConfig((PolarisConfiguration)FeatureConfiguration.SKIP_CREDENTIAL_SUBSCOPING_INDIRECTION);
        if (skipCredentialSubscopingIndirection) {
            LOGGER.atDebug().addKeyValue("tableIdentifier", (Object)tableIdentifier).log("Skipping generation of subscoped creds for table");
            return StorageAccessConfig.builder().build();
        }
        boolean allowList = storageActions.contains(PolarisStorageActions.LIST) || storageActions.contains(PolarisStorageActions.ALL);
        Set<String> writeLocations = storageActions.contains(PolarisStorageActions.WRITE) || storageActions.contains(PolarisStorageActions.DELETE) || storageActions.contains(PolarisStorageActions.ALL) ? tableLocations : Set.of();
        StorageAccessConfig accessConfig = this.storageCredentialCache.getOrGenerateSubScopeCreds(this.storageCredentialsVendor, storageInfoEntity, allowList, tableLocations, writeLocations, refreshCredentialsEndpoint);
        LOGGER.atDebug().addKeyValue("tableIdentifier", (Object)tableIdentifier).addKeyValue("credentialKeys", accessConfig.credentials().keySet()).addKeyValue("extraProperties", (Object)accessConfig.extraProperties()).log("Loaded scoped credentials for table");
        if (accessConfig.credentials().isEmpty()) {
            LOGGER.debug("No credentials found for table");
        }
        return accessConfig;
    }
}

