/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.internal.UserAgentUtils;
import software.amazon.awssdk.services.kms.model.GrantListEntry;
import software.amazon.awssdk.services.kms.model.ListRetirableGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListRetirableGrantsResponse;

public class ListRetirableGrantsIterable
implements SdkIterable<ListRetirableGrantsResponse> {
    private final KmsClient client;
    private final ListRetirableGrantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRetirableGrantsIterable(KmsClient client, ListRetirableGrantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRetirableGrantsResponseFetcher();
    }

    public Iterator<ListRetirableGrantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GrantListEntry> grants() {
        Function<ListRetirableGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.grants() != null) {
                return response.grants().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRetirableGrantsResponseFetcher
    implements SyncPageFetcher<ListRetirableGrantsResponse> {
        private ListRetirableGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListRetirableGrantsResponse previousPage) {
            return previousPage.truncated() != null && previousPage.truncated() != false;
        }

        public ListRetirableGrantsResponse nextPage(ListRetirableGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListRetirableGrantsIterable.this.client.listRetirableGrants(ListRetirableGrantsIterable.this.firstRequest);
            }
            return ListRetirableGrantsIterable.this.client.listRetirableGrants((ListRetirableGrantsRequest)((Object)ListRetirableGrantsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

