/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.dynamodb;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.aws.AwsClientFactories;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.dynamodb.DynamoDbTableOperations;
import org.apache.iceberg.aws.s3.S3FileIO;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.LocationUtil;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.Delete;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.Put;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public class DynamoDbCatalog
extends BaseMetastoreCatalog
implements SupportsNamespaces,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(DynamoDbCatalog.class);
    private static final int CATALOG_TABLE_CREATION_WAIT_ATTEMPTS_MAX = 5;
    static final Joiner COMMA = Joiner.on((char)',');
    private static final String GSI_NAMESPACE_IDENTIFIER = "namespace-identifier";
    private static final String COL_IDENTIFIER = "identifier";
    private static final String COL_IDENTIFIER_NAMESPACE = "NAMESPACE";
    private static final String COL_NAMESPACE = "namespace";
    private static final String PROPERTY_COL_PREFIX = "p.";
    private static final String PROPERTY_DEFAULT_LOCATION = "default_location";
    private static final String COL_CREATED_AT = "created_at";
    private static final String COL_UPDATED_AT = "updated_at";
    static final String COL_VERSION = "v";
    private DynamoDbClient dynamo;
    private Configuration hadoopConf;
    private String catalogName;
    private String warehousePath;
    private AwsProperties awsProperties;
    private FileIO fileIO;
    private CloseableGroup closeableGroup;
    private Map<String, String> catalogProperties;

    public void initialize(String name, Map<String, String> properties) {
        this.catalogProperties = ImmutableMap.copyOf(properties);
        this.initialize(name, properties.get("warehouse"), new AwsProperties(properties), AwsClientFactories.from(properties).dynamo(), this.initializeFileIO(properties));
    }

    @VisibleForTesting
    void initialize(String name, String path, AwsProperties properties, DynamoDbClient client, FileIO io) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0, (Object)"Cannot initialize DynamoDbCatalog because warehousePath must not be null or empty");
        this.catalogName = name;
        this.awsProperties = properties;
        this.warehousePath = LocationUtil.stripTrailingSlash((String)path);
        this.dynamo = client;
        this.fileIO = io;
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.addCloseable((AutoCloseable)this.dynamo);
        this.closeableGroup.addCloseable((Closeable)this.fileIO);
        this.closeableGroup.addCloseable((Closeable)this.metricsReporter());
        this.closeableGroup.setSuppressCloseFailure(true);
        this.ensureCatalogTableExistsOrCreate();
    }

    public String name() {
        return this.catalogName;
    }

    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        this.validateTableIdentifier(tableIdentifier);
        return new DynamoDbTableOperations(this.dynamo, this.awsProperties, this.catalogName, this.fileIO, tableIdentifier);
    }

    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        this.validateTableIdentifier(tableIdentifier);
        GetItemResponse response = this.dynamo.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).consistentRead(Boolean.valueOf(true)).key(DynamoDbCatalog.namespacePrimaryKey(tableIdentifier.namespace())).build());
        if (!response.hasItem()) {
            throw new NoSuchNamespaceException("Cannot find default warehouse location: namespace %s does not exist", new Object[]{tableIdentifier.namespace()});
        }
        String defaultLocationCol = DynamoDbCatalog.toPropertyCol(PROPERTY_DEFAULT_LOCATION);
        if (response.item().containsKey(defaultLocationCol)) {
            return String.format("%s/%s", ((AttributeValue)response.item().get(defaultLocationCol)).s(), tableIdentifier.name());
        }
        return String.format("%s/%s.db/%s", this.warehousePath, tableIdentifier.namespace(), tableIdentifier.name());
    }

    public void createNamespace(Namespace namespace, Map<String, String> metadata) {
        this.validateNamespace(namespace);
        Map<String, AttributeValue> values = DynamoDbCatalog.namespacePrimaryKey(namespace);
        DynamoDbCatalog.setNewCatalogEntryMetadata(values);
        metadata.forEach((key, value) -> values.put(DynamoDbCatalog.toPropertyCol(key), (AttributeValue)AttributeValue.builder().s(value).build()));
        try {
            this.dynamo.putItem((PutItemRequest)PutItemRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).conditionExpression("attribute_not_exists(v)").item(values).build());
        }
        catch (ConditionalCheckFailedException e) {
            throw new AlreadyExistsException("Cannot create namespace %s: already exists", new Object[]{namespace});
        }
    }

    public List<Namespace> listNamespaces(Namespace namespace) throws NoSuchNamespaceException {
        QueryResponse response;
        this.validateNamespace(namespace);
        ArrayList namespaces = Lists.newArrayList();
        Map lastEvaluatedKey = null;
        Object condition = "identifier = :identifier";
        HashMap conditionValues = Maps.newHashMap();
        conditionValues.put(":identifier", (AttributeValue)AttributeValue.builder().s(COL_IDENTIFIER_NAMESPACE).build());
        if (!namespace.isEmpty()) {
            condition = (String)condition + " AND begins_with(namespace,:ns)";
            conditionValues.put(":ns", (AttributeValue)AttributeValue.builder().s(namespace.toString()).build());
        }
        do {
            if (!(response = this.dynamo.query((QueryRequest)QueryRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).consistentRead(Boolean.valueOf(true)).keyConditionExpression((String)condition).expressionAttributeValues((Map)conditionValues).exclusiveStartKey(lastEvaluatedKey).build())).hasItems()) continue;
            for (Map item : response.items()) {
                String ns = ((AttributeValue)item.get(COL_NAMESPACE)).s();
                namespaces.add(Namespace.of((String[])ns.split("\\.")));
            }
        } while (!(lastEvaluatedKey = response.lastEvaluatedKey()).isEmpty());
        return namespaces;
    }

    public Map<String, String> loadNamespaceMetadata(Namespace namespace) throws NoSuchNamespaceException {
        this.validateNamespace(namespace);
        GetItemResponse response = this.dynamo.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).consistentRead(Boolean.valueOf(true)).key(DynamoDbCatalog.namespacePrimaryKey(namespace)).build());
        if (!response.hasItem()) {
            throw new NoSuchNamespaceException("Cannot find namespace %s", new Object[]{namespace});
        }
        return response.item().entrySet().stream().filter(e -> DynamoDbCatalog.isProperty((String)e.getKey())).collect(Collectors.toMap(e -> DynamoDbCatalog.toPropertyKey((String)e.getKey()), e -> ((AttributeValue)e.getValue()).s()));
    }

    public boolean dropNamespace(Namespace namespace) throws NamespaceNotEmptyException {
        this.validateNamespace(namespace);
        if (!this.listTables(namespace).isEmpty()) {
            throw new NamespaceNotEmptyException("Cannot delete non-empty namespace %s", new Object[]{namespace});
        }
        try {
            this.dynamo.deleteItem((DeleteItemRequest)DeleteItemRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).key(DynamoDbCatalog.namespacePrimaryKey(namespace)).conditionExpression("attribute_exists(namespace)").build());
            return true;
        }
        catch (ConditionalCheckFailedException e) {
            return false;
        }
    }

    public boolean setProperties(Namespace namespace, Map<String, String> properties) throws NoSuchNamespaceException {
        ArrayList updateParts = Lists.newArrayList();
        HashMap attributeNames = Maps.newHashMap();
        HashMap attributeValues = Maps.newHashMap();
        int idx = 0;
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String attributeValue = ":v" + idx;
            String attributeKey = "#k" + idx;
            ++idx;
            updateParts.add(attributeKey + " = " + attributeValue);
            attributeNames.put(attributeKey, DynamoDbCatalog.toPropertyCol(property.getKey()));
            attributeValues.put(attributeValue, (AttributeValue)AttributeValue.builder().s(property.getValue()).build());
        }
        DynamoDbCatalog.updateCatalogEntryMetadata(updateParts, attributeValues);
        String updateExpression = "SET " + COMMA.join((Iterable)updateParts);
        return this.updateProperties(namespace, updateExpression, attributeValues, attributeNames);
    }

    public boolean removeProperties(Namespace namespace, Set<String> properties) throws NoSuchNamespaceException {
        ArrayList removeParts = Lists.newArrayList(properties.iterator());
        HashMap attributeNames = Maps.newHashMap();
        HashMap attributeValues = Maps.newHashMap();
        int idx = 0;
        for (String property : properties) {
            String attributeKey = "#k" + idx;
            ++idx;
            removeParts.add(attributeKey);
            attributeNames.put(attributeKey, DynamoDbCatalog.toPropertyCol(property));
        }
        ArrayList updateParts = Lists.newArrayList();
        DynamoDbCatalog.updateCatalogEntryMetadata(updateParts, attributeValues);
        String updateExpression = "REMOVE " + COMMA.join((Iterable)removeParts) + " SET " + COMMA.join((Iterable)updateParts);
        return this.updateProperties(namespace, updateExpression, attributeValues, attributeNames);
    }

    public List<TableIdentifier> listTables(Namespace namespace) {
        QueryResponse response;
        ArrayList identifiers = Lists.newArrayList();
        Map lastEvaluatedKey = null;
        String condition = "namespace = :ns";
        ImmutableMap conditionValues = ImmutableMap.of((Object)":ns", (Object)((AttributeValue)AttributeValue.builder().s(namespace.toString()).build()));
        do {
            if (!(response = this.dynamo.query((QueryRequest)QueryRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).indexName(GSI_NAMESPACE_IDENTIFIER).keyConditionExpression(condition).expressionAttributeValues((Map)conditionValues).exclusiveStartKey(lastEvaluatedKey).build())).hasItems()) continue;
            for (Map item : response.items()) {
                String identifier = ((AttributeValue)item.get(COL_IDENTIFIER)).s();
                if (COL_IDENTIFIER_NAMESPACE.equals(identifier)) continue;
                identifiers.add(TableIdentifier.of((String[])identifier.split("\\.")));
            }
        } while (!(lastEvaluatedKey = response.lastEvaluatedKey()).isEmpty());
        return identifiers;
    }

    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        Map<String, AttributeValue> key = DynamoDbCatalog.tablePrimaryKey(identifier);
        try {
            GetItemResponse response = this.dynamo.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).consistentRead(Boolean.valueOf(true)).key(key).build());
            if (!response.hasItem()) {
                throw new NoSuchTableException("Cannot find table %s to drop", new Object[]{identifier});
            }
            TableOperations ops = this.newTableOps(identifier);
            TableMetadata lastMetadata = null;
            if (purge) {
                try {
                    lastMetadata = ops.current();
                }
                catch (NotFoundException e) {
                    LOG.warn("Failed to load table metadata for table: {}, continuing drop without purge", (Object)identifier, (Object)e);
                }
            }
            this.dynamo.deleteItem((DeleteItemRequest)DeleteItemRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).key(DynamoDbCatalog.tablePrimaryKey(identifier)).conditionExpression("v = :v").expressionAttributeValues((Map)ImmutableMap.of((Object)":v", (Object)((AttributeValue)response.item().get(COL_VERSION)))).build());
            LOG.info("Successfully dropped table {} from DynamoDb catalog", (Object)identifier);
            if (purge && lastMetadata != null) {
                CatalogUtil.dropTableData((FileIO)ops.io(), (TableMetadata)lastMetadata);
                LOG.info("Table {} data purged", (Object)identifier);
            }
            LOG.info("Dropped table: {}", (Object)identifier);
            return true;
        }
        catch (ConditionalCheckFailedException e) {
            LOG.error("Cannot complete drop table operation for {}: commit conflict", (Object)identifier, (Object)e);
            return false;
        }
        catch (Exception e) {
            LOG.error("Cannot complete drop table operation for {}: unexpected exception", (Object)identifier, (Object)e);
            throw e;
        }
    }

    public void renameTable(TableIdentifier from, TableIdentifier to) {
        Map<String, AttributeValue> fromKey = DynamoDbCatalog.tablePrimaryKey(from);
        Map<String, AttributeValue> toKey = DynamoDbCatalog.tablePrimaryKey(to);
        GetItemResponse fromResponse = this.dynamo.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).consistentRead(Boolean.valueOf(true)).key(fromKey).build());
        if (!fromResponse.hasItem()) {
            throw new NoSuchTableException("Cannot rename table %s to %s: %s does not exist", new Object[]{from, to, from});
        }
        GetItemResponse toResponse = this.dynamo.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).consistentRead(Boolean.valueOf(true)).key(toKey).build());
        if (toResponse.hasItem()) {
            throw new AlreadyExistsException("Cannot rename table %s to %s: %s already exists", new Object[]{from, to, to});
        }
        fromResponse.item().entrySet().stream().filter(e -> DynamoDbCatalog.isProperty((String)e.getKey())).forEach(e -> toKey.put((String)e.getKey(), (AttributeValue)e.getValue()));
        DynamoDbCatalog.setNewCatalogEntryMetadata(toKey);
        this.dynamo.transactWriteItems((TransactWriteItemsRequest)TransactWriteItemsRequest.builder().transactItems(new TransactWriteItem[]{(TransactWriteItem)TransactWriteItem.builder().delete((Delete)Delete.builder().tableName(this.awsProperties.dynamoDbTableName()).key(fromKey).conditionExpression("v = :v").expressionAttributeValues((Map)ImmutableMap.of((Object)":v", (Object)((AttributeValue)fromResponse.item().get(COL_VERSION)))).build()).build(), (TransactWriteItem)TransactWriteItem.builder().put((Put)Put.builder().tableName(this.awsProperties.dynamoDbTableName()).item(toKey).conditionExpression("attribute_not_exists(v)").build()).build()}).build());
        LOG.info("Successfully renamed table from {} to {}", (Object)from, (Object)to);
    }

    public void setConf(Configuration conf) {
        this.hadoopConf = conf;
    }

    public Configuration getConf() {
        return this.hadoopConf;
    }

    public void close() throws IOException {
        this.closeableGroup.close();
    }

    public static String defaultLocationProperty() {
        return PROPERTY_DEFAULT_LOCATION;
    }

    static String toPropertyCol(String propertyKey) {
        return PROPERTY_COL_PREFIX + propertyKey;
    }

    static boolean isProperty(String dynamoCol) {
        return dynamoCol.startsWith(PROPERTY_COL_PREFIX);
    }

    static String toPropertyKey(String propertyCol) {
        return propertyCol.substring(PROPERTY_COL_PREFIX.length());
    }

    static Map<String, AttributeValue> namespacePrimaryKey(Namespace namespace) {
        HashMap key = Maps.newHashMap();
        key.put(COL_IDENTIFIER, (AttributeValue)AttributeValue.builder().s(COL_IDENTIFIER_NAMESPACE).build());
        key.put(COL_NAMESPACE, (AttributeValue)AttributeValue.builder().s(namespace.toString()).build());
        return key;
    }

    static Map<String, AttributeValue> tablePrimaryKey(TableIdentifier identifier) {
        HashMap key = Maps.newHashMap();
        key.put(COL_IDENTIFIER, (AttributeValue)AttributeValue.builder().s(identifier.toString()).build());
        key.put(COL_NAMESPACE, (AttributeValue)AttributeValue.builder().s(identifier.namespace().toString()).build());
        return key;
    }

    static void setNewCatalogEntryMetadata(Map<String, AttributeValue> values) {
        String current = Long.toString(System.currentTimeMillis());
        values.put(COL_CREATED_AT, (AttributeValue)AttributeValue.builder().n(current).build());
        values.put(COL_UPDATED_AT, (AttributeValue)AttributeValue.builder().n(current).build());
        values.put(COL_VERSION, (AttributeValue)AttributeValue.builder().s(UUID.randomUUID().toString()).build());
    }

    static void updateCatalogEntryMetadata(List<String> updateParts, Map<String, AttributeValue> attributeValues) {
        updateParts.add("updated_at = :uat");
        attributeValues.put(":uat", (AttributeValue)AttributeValue.builder().n(Long.toString(System.currentTimeMillis())).build());
        updateParts.add("v = :uv");
        attributeValues.put(":uv", (AttributeValue)AttributeValue.builder().s(UUID.randomUUID().toString()).build());
    }

    private FileIO initializeFileIO(Map<String, String> properties) {
        String fileIOImpl = properties.get("io-impl");
        if (fileIOImpl == null) {
            S3FileIO io = new S3FileIO();
            io.initialize(properties);
            return io;
        }
        return CatalogUtil.loadFileIO((String)fileIOImpl, properties, (Object)this.hadoopConf);
    }

    private void validateNamespace(Namespace namespace) {
        for (String level : namespace.levels()) {
            ValidationException.check((level != null && !level.isEmpty() ? 1 : 0) != 0, (String)"Namespace level must not be empty: %s", (Object[])new Object[]{namespace});
            ValidationException.check((!level.contains(".") ? 1 : 0) != 0, (String)"Namespace level must not contain dot, but found %s in %s", (Object[])new Object[]{level, namespace});
        }
    }

    private void validateTableIdentifier(TableIdentifier identifier) {
        this.validateNamespace(identifier.namespace());
        ValidationException.check((boolean)identifier.hasNamespace(), (String)"Table namespace must not be empty: %s", (Object[])new Object[]{identifier});
        String tableName = identifier.name();
        ValidationException.check((!tableName.contains(".") ? 1 : 0) != 0, (String)"Table name must not contain dot: %s", (Object[])new Object[]{tableName});
    }

    private boolean dynamoDbTableExists(String tableName) {
        try {
            this.dynamo.describeTable((DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build());
            return true;
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
    }

    private void ensureCatalogTableExistsOrCreate() {
        if (this.dynamoDbTableExists(this.awsProperties.dynamoDbTableName())) {
            return;
        }
        LOG.info("DynamoDb catalog table {} not found, trying to create", (Object)this.awsProperties.dynamoDbTableName());
        this.dynamo.createTable((CreateTableRequest)CreateTableRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName(COL_IDENTIFIER).keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName(COL_NAMESPACE).keyType(KeyType.RANGE).build()}).attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName(COL_IDENTIFIER).attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName(COL_NAMESPACE).attributeType(ScalarAttributeType.S).build()}).globalSecondaryIndexes(new GlobalSecondaryIndex[]{(GlobalSecondaryIndex)GlobalSecondaryIndex.builder().indexName(GSI_NAMESPACE_IDENTIFIER).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName(COL_NAMESPACE).keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName(COL_IDENTIFIER).keyType(KeyType.RANGE).build()}).projection((Projection)Projection.builder().projectionType(ProjectionType.KEYS_ONLY).build()).build()}).billingMode(BillingMode.PAY_PER_REQUEST).build());
        Tasks.foreach((Object[])new String[]{this.awsProperties.dynamoDbTableName()}).retry(5).throwFailureWhenFinished().onlyRetryOn(IllegalStateException.class).run(this::checkTableActive);
    }

    private void checkTableActive(String tableName) {
        try {
            DescribeTableResponse response = this.dynamo.describeTable((DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build());
            TableStatus currentStatus = response.table().tableStatus();
            if (!currentStatus.equals((Object)TableStatus.ACTIVE)) {
                throw new IllegalStateException(String.format("Dynamo catalog table %s is not active, current status: %s", tableName, currentStatus));
            }
        }
        catch (ResourceNotFoundException e) {
            throw new IllegalStateException(String.format("Cannot find Dynamo catalog table %s", tableName));
        }
    }

    private boolean updateProperties(Namespace namespace, String updateExpression, Map<String, AttributeValue> attributeValues, Map<String, String> attributeNames) {
        this.validateNamespace(namespace);
        Map<String, AttributeValue> key = DynamoDbCatalog.namespacePrimaryKey(namespace);
        try {
            GetItemResponse response = this.dynamo.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).consistentRead(Boolean.valueOf(true)).key(key).build());
            if (!response.hasItem()) {
                throw new NoSuchNamespaceException("Cannot find namespace %s", new Object[]{namespace});
            }
            attributeValues.put(":v", (AttributeValue)response.item().get(COL_VERSION));
            this.dynamo.updateItem((UpdateItemRequest)UpdateItemRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).key(key).conditionExpression("v = :v").updateExpression(updateExpression).expressionAttributeValues(attributeValues).expressionAttributeNames(attributeNames).build());
            return true;
        }
        catch (ConditionalCheckFailedException e) {
            return false;
        }
    }

    protected Map<String, String> properties() {
        return this.catalogProperties == null ? ImmutableMap.of() : this.catalogProperties;
    }
}

