/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.paimon.append.BucketedAppendCompactManager;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.utils.BinPacking;

public class AppendOnlySplitGenerator
implements SplitGenerator {
    private final long targetSplitSize;
    private final long openFileCost;
    private final BucketMode bucketMode;

    public AppendOnlySplitGenerator(long targetSplitSize, long openFileCost, BucketMode bucketMode) {
        this.targetSplitSize = targetSplitSize;
        this.openFileCost = openFileCost;
        this.bucketMode = bucketMode;
    }

    @Override
    public boolean alwaysRawConvertible() {
        return true;
    }

    @Override
    public List<SplitGenerator.SplitGroup> splitForBatch(List<DataFileMeta> input) {
        ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>(input);
        files.sort(BucketedAppendCompactManager.fileComparator(this.bucketMode == BucketMode.BUCKET_UNAWARE));
        Function<DataFileMeta, Long> weightFunc = file -> Math.max(file.fileSize(), this.openFileCost);
        return BinPacking.packForOrdered(files, weightFunc, this.targetSplitSize).stream().map(SplitGenerator.SplitGroup::rawConvertibleGroup).collect(Collectors.toList());
    }

    @Override
    public List<SplitGenerator.SplitGroup> splitForStreaming(List<DataFileMeta> files) {
        if (this.bucketMode == BucketMode.BUCKET_UNAWARE) {
            return this.splitForBatch(files);
        }
        return Collections.singletonList(SplitGenerator.SplitGroup.rawConvertibleGroup(files));
    }
}

