/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.io.DataInputViewStreamWrapper;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.io.IndexIncrement;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageSerializer;
import org.apache.paimon.utils.SerializationUtils;

public class CommitMessageImpl
implements CommitMessage {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<CommitMessageSerializer> CACHE = ThreadLocal.withInitial(CommitMessageSerializer::new);
    private transient BinaryRow partition;
    private transient int bucket;
    @Nullable
    private transient Integer totalBuckets;
    private transient DataIncrement dataIncrement;
    private transient CompactIncrement compactIncrement;
    private transient IndexIncrement indexIncrement;

    @VisibleForTesting
    public CommitMessageImpl(BinaryRow partition, int bucket, @Nullable Integer totalBuckets, DataIncrement dataIncrement, CompactIncrement compactIncrement) {
        this(partition, bucket, totalBuckets, dataIncrement, compactIncrement, new IndexIncrement(Collections.emptyList()));
    }

    public CommitMessageImpl(BinaryRow partition, int bucket, @Nullable Integer totalBuckets, DataIncrement dataIncrement, CompactIncrement compactIncrement, IndexIncrement indexIncrement) {
        this.partition = partition;
        this.bucket = bucket;
        this.totalBuckets = totalBuckets;
        this.dataIncrement = dataIncrement;
        this.compactIncrement = compactIncrement;
        this.indexIncrement = indexIncrement;
    }

    @Override
    public BinaryRow partition() {
        return this.partition;
    }

    @Override
    public int bucket() {
        return this.bucket;
    }

    @Override
    @Nullable
    public Integer totalBuckets() {
        return this.totalBuckets;
    }

    public DataIncrement newFilesIncrement() {
        return this.dataIncrement;
    }

    public CompactIncrement compactIncrement() {
        return this.compactIncrement;
    }

    public IndexIncrement indexIncrement() {
        return this.indexIncrement;
    }

    public boolean isEmpty() {
        return this.dataIncrement.isEmpty() && this.compactIncrement.isEmpty() && this.indexIncrement.isEmpty();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        CommitMessageSerializer serializer = CACHE.get();
        out.writeInt(serializer.getVersion());
        SerializationUtils.serializeBytes(new DataOutputViewStreamWrapper(out), serializer.serialize(this));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
        byte[] bytes = SerializationUtils.deserializedBytes(new DataInputViewStreamWrapper(in));
        CommitMessageImpl message = (CommitMessageImpl)CACHE.get().deserialize(version, bytes);
        this.partition = message.partition;
        this.bucket = message.bucket;
        this.totalBuckets = message.totalBuckets;
        this.dataIncrement = message.dataIncrement;
        this.compactIncrement = message.compactIncrement;
        this.indexIncrement = message.indexIncrement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitMessageImpl that = (CommitMessageImpl)o;
        return this.bucket == that.bucket && Objects.equals(this.partition, that.partition) && Objects.equals(this.totalBuckets, that.totalBuckets) && Objects.equals(this.dataIncrement, that.dataIncrement) && Objects.equals(this.compactIncrement, that.compactIncrement) && Objects.equals(this.indexIncrement, that.indexIncrement);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.bucket, this.totalBuckets, this.dataIncrement, this.compactIncrement, this.indexIncrement);
    }

    public String toString() {
        return String.format("FileCommittable {partition = %s, bucket = %d, totalBuckets = %s, newFilesIncrement = %s, compactIncrement = %s, indexIncrement = %s}", this.partition, this.bucket, this.totalBuckets, this.dataIncrement, this.compactIncrement, this.indexIncrement);
    }
}

