/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.ThreadPoolUtils;

public class ListUnexistingFiles {
    private final FileStoreTable table;
    private final FileStorePathFactory pathFactory;
    private final ThreadPoolExecutor executor;

    public ListUnexistingFiles(FileStoreTable table) {
        this.table = table;
        this.pathFactory = table.store().pathFactory();
        this.executor = ThreadPoolUtils.createCachedThreadPool(table.coreOptions().deleteFileThreadNum(), "LIST_UNEXISTING_FILES");
    }

    public Map<Integer, Map<String, DataFileMeta>> list(BinaryRow partition) throws Exception {
        HashMap<Integer, Map<String, DataFileMeta>> result = new HashMap<Integer, Map<String, DataFileMeta>>();
        List<Split> splits = this.table.newScan().withPartitionFilter(Collections.singletonList(partition)).plan().splits();
        Iterator it = ThreadPoolUtils.randomlyExecuteSequentialReturn(this.executor, split -> this.listFilesInDataSplit((DataSplit)split), splits);
        while (it.hasNext()) {
            ListResult item = (ListResult)it.next();
            result.computeIfAbsent(item.bucket, k -> new HashMap()).put(item.path, item.meta);
        }
        return result;
    }

    private List<ListResult> listFilesInDataSplit(DataSplit dataSplit) {
        ArrayList<ListResult> results = new ArrayList<ListResult>();
        DataFilePathFactory dataFilePathFactory = this.pathFactory.createDataFilePathFactory(dataSplit.partition(), dataSplit.bucket());
        for (DataFileMeta meta : dataSplit.dataFiles()) {
            Path path = dataFilePathFactory.toPath(meta);
            try {
                if (this.table.fileIO().exists(path)) continue;
                results.add(new ListResult(dataSplit.bucket(), path.toString(), meta));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Cannot determine if file " + path + " exists.", e);
            }
        }
        return results;
    }

    private static class ListResult {
        private final int bucket;
        private final String path;
        private final DataFileMeta meta;

        private ListResult(int bucket, String path, DataFileMeta meta) {
            this.bucket = bucket;
            this.path = path;
            this.meta = meta;
        }
    }
}

