/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.fesod.sheet.constant;

/**
 * Order constant.
 *
 *
 */
public class OrderConstant {

    /**
     * The system's own style
     */
    public static int DEFAULT_DEFINE_STYLE = -70000;

    /**
     * Annotation style definition
     */
    public static int ANNOTATION_DEFINE_STYLE = -60000;

    /**
     * Define style.
     */
    public static final int DEFINE_STYLE = -50000;

    /**
     * default order.
     */
    public static int DEFAULT_ORDER = 0;

    /**
     * Sorting of styles written to cells.
     */
    public static int FILL_STYLE = 50000;

    /**
     * Sorting of sheets
     */
    public static int SHEET_ORDER = 60000;
}
