/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store.delay;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.bifromq.inbox.record.TenantInboxInstance;
import org.apache.bifromq.inbox.store.delay.IDelayTaskRunner;
import org.apache.bifromq.inbox.store.delay.IDelayedTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RetryableDelayedTask<R>
implements IDelayedTask<TenantInboxInstance> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryableDelayedTask.class);
    protected final Duration delay;
    protected final int retryCount;
    protected final long mod;

    protected RetryableDelayedTask(Duration delay, long mod, int retryCount) {
        this.delay = delay;
        this.mod = mod;
        this.retryCount = retryCount;
    }

    @Override
    public final CompletableFuture<Void> run(TenantInboxInstance key, IDelayTaskRunner<TenantInboxInstance> runner) {
        if (this.retryCount > 5) {
            log.debug("{} failed after {} retries, tenantId={}, inboxId={}, inc={}", new Object[]{this.getTaskName(), this.retryCount, key.tenantId(), key.instance().inboxId(), key.instance().incarnation()});
            return CompletableFuture.completedFuture(null);
        }
        return this.callOperation(key, runner).thenAccept(response -> {
            if (this.shouldRetry(response)) {
                Duration retryDelay = Duration.ofMillis(ThreadLocalRandom.current().nextLong(100L, 5000L));
                runner.schedule(key, this.createRetryTask(retryDelay));
            }
        });
    }

    protected abstract CompletableFuture<R> callOperation(TenantInboxInstance var1, IDelayTaskRunner<TenantInboxInstance> var2);

    protected abstract boolean shouldRetry(R var1);

    protected abstract RetryableDelayedTask<R> createRetryTask(Duration var1);

    protected abstract String getTaskName();

    @Override
    public final Duration getDelay() {
        return this.delay;
    }
}

