/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.apiserver.http.handler.TenantAwareHandler;
import org.apache.bifromq.apiserver.http.handler.utils.HeaderUtils;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.apache.bifromq.sessiondict.rpc.proto.KillAllReply;
import org.apache.bifromq.sessiondict.rpc.proto.KillReply;
import org.apache.bifromq.sessiondict.rpc.proto.ServerRedirection;
import org.apache.bifromq.type.ClientInfo;

@Path(value="/kill")
final class KillHandler
extends TenantAwareHandler {
    private static final int MAX_SERVER_REFERENCE_LENGTH = 65535;
    private static final String SERVER_REDIRECT_VALUE_NO = "no";
    private static final String SERVER_REDIRECT_VALUE_MOVE = "move";
    private static final String SERVER_REDIRECT_VALUE_TEMP_USE = "temp_use";
    private static final Set<String> SERVER_REDIRECT_VALUES = Set.of("no", "move", "temp_use");
    private static final ByteBuf INVALID_SERVER_REDIRECT = Unpooled.wrappedBuffer((byte[])"Invalid server redirect value".getBytes());
    private static final ByteBuf TOO_LONG_SERVER_REFERENCE = Unpooled.wrappedBuffer((byte[])"Server reference exceeds 65535 bytes".getBytes());
    private final ISessionDictClient sessionDictClient;

    KillHandler(ISettingProvider settingProvider, ISessionDictClient sessionDictClient) {
        super(settingProvider);
        this.sessionDictClient = sessionDictClient;
    }

    @Override
    @DELETE
    @Operation(summary="Disconnect a MQTT client connection")
    @Parameters(value={@Parameter(name="req_id", in=ParameterIn.HEADER, description="optional caller provided request id", schema=@Schema(implementation=Long.class)), @Parameter(name="tenant_id", in=ParameterIn.HEADER, required=true, description="the tenant id", schema=@Schema(implementation=String.class)), @Parameter(name="user_id", in=ParameterIn.HEADER, description="the user id of the MQTT client connection to be disconnected", schema=@Schema(implementation=String.class)), @Parameter(name="client_id", in=ParameterIn.HEADER, description="the client id of the mqtt session"), @Parameter(name="server_redirect", in=ParameterIn.HEADER, description="indicate if the client should redirect to another server", schema=@Schema(implementation=String.class, allowableValues={"no", "move", "temp_use"})), @Parameter(name="server_reference", in=ParameterIn.HEADER, description="indicate the server reference to redirect to", schema=@Schema(implementation=String.class, maxLength=65535)), @Parameter(name="client_type", in=ParameterIn.HEADER, required=true, description="the caller client type", schema=@Schema(implementation=String.class)), @Parameter(name="client_meta_*", in=ParameterIn.HEADER, description="the metadata header about the caller client, must be started with client_meta_")})
    @RequestBody(required=false)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=String.class))})})
    public CompletableFuture<FullHttpResponse> handle(@Parameter(hidden=true) long reqId, @Parameter(hidden=true) String tenantId, @Parameter(hidden=true) FullHttpRequest req) {
        String userId = HeaderUtils.getHeader(Headers.HEADER_USER_ID, (HttpRequest)req, false);
        String clientId = HeaderUtils.getHeader(Headers.HEADER_CLIENT_ID, (HttpRequest)req, false);
        String serverRedirect = HeaderUtils.getHeader(Headers.HEADER_SERVER_REDIRECT, (HttpRequest)req, false);
        String serverReference = HeaderUtils.getHeader(Headers.HEADER_SERVER_REFERENCE, (HttpRequest)req, false);
        String clientType = HeaderUtils.getHeader(Headers.HEADER_CLIENT_TYPE, (HttpRequest)req, true);
        Map<String, String> clientMeta = HeaderUtils.getClientMeta((HttpRequest)req);
        if (serverRedirect != null && !SERVER_REDIRECT_VALUES.contains(serverRedirect)) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.BAD_REQUEST, INVALID_SERVER_REDIRECT));
        }
        if (serverReference != null && serverReference.length() > 65535) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.BAD_REQUEST, TOO_LONG_SERVER_REFERENCE));
        }
        ServerRedirection serverRedirection = this.buildServerRedirection(serverRedirect, serverReference);
        if (Strings.isNullOrEmpty((String)userId) || Strings.isNullOrEmpty((String)clientId)) {
            return this.sessionDictClient.killAll(reqId, tenantId, userId, ClientInfo.newBuilder().setTenantId(tenantId).setType(clientType).putAllMetadata(clientMeta).build(), serverRedirection).thenApply(v -> new DefaultFullHttpResponse(req.protocolVersion(), v.getResult() == KillAllReply.Result.OK ? HttpResponseStatus.OK : HttpResponseStatus.NOT_FOUND, Unpooled.EMPTY_BUFFER));
        }
        return this.sessionDictClient.kill(reqId, tenantId, userId, clientId, ClientInfo.newBuilder().setTenantId(tenantId).setType(clientType).putAllMetadata(clientMeta).build(), serverRedirection).thenApply(v -> new DefaultFullHttpResponse(req.protocolVersion(), v.getResult() == KillReply.Result.OK ? HttpResponseStatus.OK : HttpResponseStatus.NOT_FOUND, Unpooled.EMPTY_BUFFER));
    }

    private ServerRedirection buildServerRedirection(String serverRedirect, String serverReference) {
        if (Strings.isNullOrEmpty((String)serverRedirect)) {
            return ServerRedirection.newBuilder().setType(ServerRedirection.Type.NO_MOVE).build();
        }
        switch (serverRedirect) {
            case "move": {
                ServerRedirection.Builder builder = ServerRedirection.newBuilder().setType(ServerRedirection.Type.PERMANENT_MOVE);
                if (!Strings.isNullOrEmpty((String)serverReference)) {
                    builder.setServerReference(serverReference);
                }
                return builder.build();
            }
            case "temp_use": {
                ServerRedirection.Builder builder = ServerRedirection.newBuilder().setType(ServerRedirection.Type.TEMPORARY_MOVE);
                if (!Strings.isNullOrEmpty((String)serverReference)) {
                    builder.setServerReference(serverReference);
                }
                return builder.build();
            }
        }
        return ServerRedirection.newBuilder().setType(ServerRedirection.Type.NO_MOVE).build();
    }
}

