/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.memberlist;

import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.bifromq.basecluster.memberlist.IHostAddressResolver;
import org.apache.bifromq.basecluster.memberlist.IHostMemberList;
import org.apache.bifromq.basecluster.membership.proto.HostEndpoint;
import org.apache.bifromq.basecluster.messenger.IRecipient;
import org.apache.bifromq.basecluster.messenger.IRecipientSelector;

public class MemberSelector
implements IRecipientSelector {
    private final Disposable disposable;
    private volatile List<IRecipient> recipients = new ArrayList<IRecipient>();

    public MemberSelector(IHostMemberList memberList, Scheduler scheduler, IHostAddressResolver addressResolver) {
        this.disposable = memberList.members().observeOn(scheduler).subscribe(members -> {
            this.recipients = members.keySet().stream().map(m -> {
                InetSocketAddress address = addressResolver.resolve((HostEndpoint)m);
                return () -> address;
            }).collect(Collectors.toList());
        });
    }

    @Override
    public Collection<? extends IRecipient> selectForSpread(int limit) {
        List<IRecipient> addresses = this.recipients;
        if (addresses.size() <= limit) {
            return addresses;
        }
        Collections.shuffle(addresses);
        return addresses.subList(0, limit);
    }

    @Override
    public int clusterSize() {
        return this.recipients.size();
    }

    public void stop() {
        this.disposable.dispose();
    }
}

