/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sysprops.parser;

import org.apache.bifromq.sysprops.parser.PropParser;
import org.apache.bifromq.sysprops.parser.SysPropParseException;

public class IntegerParser
implements PropParser<Integer> {
    public static final IntegerParser POSITIVE = new IntegerParser(1, Integer.MAX_VALUE);
    public static final IntegerParser NON_NEGATIVE = new IntegerParser(0, Integer.MAX_VALUE);
    private final int lowBound;
    private final int highBoundEx;

    private IntegerParser(int lowBound, int highBoundEx) {
        this.lowBound = lowBound;
        this.highBoundEx = highBoundEx;
    }

    @Override
    public Integer parse(String value) {
        int val;
        int n = val = this.lowBound >= 0 ? Integer.parseUnsignedInt(value) : Integer.parseInt(value);
        if (this.lowBound <= val && val < this.highBoundEx) {
            return val;
        }
        throw new SysPropParseException(String.format("%d is out of bound [%d,%d)", val, this.lowBound, this.highBoundEx));
    }

    public static IntegerParser from(int lowBound, int highBoundEx) {
        assert (lowBound < highBoundEx);
        return new IntegerParser(lowBound, highBoundEx);
    }
}

