/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.metrics;

import io.grpc.MethodDescriptor;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.EnumMap;
import org.apache.bifromq.baserpc.BluePrint;
import org.apache.bifromq.baserpc.metrics.IRPCMeter;
import org.apache.bifromq.baserpc.metrics.RPCMetric;

public class RPCMethodMeter
implements IRPCMeter.IRPCMethodMeter {
    private final EnumMap<RPCMetric, Meter> meters = new EnumMap(RPCMetric.class);

    public RPCMethodMeter(String serviceName, MethodDescriptor<?, ?> methodDesc, BluePrint.MethodSemantic semantic) {
        for (RPCMetric metric : RPCMetric.values()) {
            if (metric.methodType != semantic.type()) continue;
            Tags tags = Tags.of((String)"service", (String)serviceName).and("method", methodDesc.getBareMethodName() == null ? methodDesc.getFullMethodName() : methodDesc.getBareMethodName());
            this.meters.put(metric, (Meter)(switch (metric.meterType) {
                case Meter.Type.TIMER -> Timer.builder((String)metric.metricName).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
                case Meter.Type.COUNTER -> Metrics.counter((String)metric.metricName, (Iterable)tags);
                case Meter.Type.DISTRIBUTION_SUMMARY -> DistributionSummary.builder((String)metric.metricName).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
                default -> throw new IllegalStateException("Unsupported Meter Type: " + String.valueOf(metric.meterType));
            }));
        }
    }

    @Override
    public void recordCount(RPCMetric metric) {
        assert (metric.meterType == Meter.Type.COUNTER);
        ((Counter)this.meters.get((Object)metric)).increment();
    }

    @Override
    public void recordCount(RPCMetric metric, double inc) {
        assert (metric.meterType == Meter.Type.COUNTER);
        ((Counter)this.meters.get((Object)metric)).increment(inc);
    }

    @Override
    public Timer timer(RPCMetric metric) {
        assert (metric.meterType == Meter.Type.TIMER);
        return (Timer)this.meters.get((Object)metric);
    }

    @Override
    public void recordSummary(RPCMetric metric, int depth) {
        assert (metric.meterType == Meter.Type.DISTRIBUTION_SUMMARY);
        ((DistributionSummary)this.meters.get((Object)metric)).record((double)depth);
    }
}

