/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import java.util.LinkedList;
import java.util.Optional;
import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.PeerLogReplicatorState;
import org.apache.bifromq.basekv.raft.PeerLogReplicatorStateProbing;
import org.apache.bifromq.basekv.raft.PeerLogReplicatorStateSnapshotSyncing;
import org.apache.bifromq.basekv.raft.RaftConfig;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.raft.proto.RaftNodeSyncState;
import org.slf4j.Logger;

class PeerLogReplicatorStateReplicating
extends PeerLogReplicatorState {
    private final LinkedList<Long> inflightAppends;
    private int heartbeatElapsedTick;
    private boolean needHeartbeat;
    private long lastMatchIndex;
    private long catchupRate;
    private int fullElapsedTick = -1;
    private int unconfirmedHeartbeatTick = 0;

    PeerLogReplicatorStateReplicating(String peerId, RaftConfig config, IRaftStateStore stateStorage, long matchIndex, long nextIndex, Logger logger) {
        super(peerId, config, stateStorage, matchIndex, nextIndex, logger);
        this.lastMatchIndex = matchIndex;
        this.inflightAppends = new LinkedList();
    }

    @Override
    public RaftNodeSyncState state() {
        return RaftNodeSyncState.Replicating;
    }

    @Override
    public PeerLogReplicatorState tick() {
        if (this.heartbeatElapsedTick >= this.config.getHeartbeatTimeoutTick()) {
            this.needHeartbeat = true;
        }
        ++this.heartbeatElapsedTick;
        if (this.isFull()) {
            if (this.needHeartbeat) {
                this.inflightAppends.removeFirst();
            }
            ++this.fullElapsedTick;
        }
        this.catchupRate = this.matchIndex - this.lastMatchIndex;
        this.lastMatchIndex = this.matchIndex;
        if (this.catchupRate == 0L && this.fullElapsedTick >= this.config.getElectionTimeoutTick() || this.unconfirmedHeartbeatTick >= this.config.getElectionTimeoutTick()) {
            return new PeerLogReplicatorStateProbing(this.peerId, this.config, this.stateStorage, this.matchIndex, this.matchIndex + 1L, this.logger);
        }
        return this;
    }

    @Override
    public long catchupRate() {
        return this.catchupRate;
    }

    @Override
    public boolean pauseReplicating() {
        return this.isFull();
    }

    @Override
    public boolean needHeartbeat() {
        return this.needHeartbeat;
    }

    @Override
    public PeerLogReplicatorState backoff(long peerRejectedIndex, long peerLastIndex) {
        if (peerRejectedIndex < this.matchIndex) {
            return this;
        }
        Optional<LogEntry> prevLogEntry = this.stateStorage.entryAt(peerLastIndex);
        if (prevLogEntry.isEmpty()) {
            this.logger.debug("Entry[index:{}] not available for peer[{}] from tracker[matchIndex:{},nextIndex:{},state:{}], start syncing with snapshot", new Object[]{peerLastIndex, this.peerId, this.matchIndex, this.nextIndex, this.state()});
            return new PeerLogReplicatorStateSnapshotSyncing(this.peerId, this.config, this.stateStorage, this.logger);
        }
        long probeStartIndex = Math.min(peerLastIndex, this.matchIndex);
        this.logger.debug("Peer[{}] with last index[{}] rejected appending entries from tracker[matchIndex:{},nextIndex:{},state:{}], start probing", new Object[]{this.peerId, peerLastIndex, this.matchIndex, this.nextIndex, this.state()});
        return new PeerLogReplicatorStateProbing(this.peerId, this.config, this.stateStorage, probeStartIndex, probeStartIndex + 1L, this.logger);
    }

    @Override
    public PeerLogReplicatorState confirmMatch(long peerLastIndex) {
        if (this.matchIndex < peerLastIndex) {
            this.matchIndex = peerLastIndex;
        }
        if (this.nextIndex < peerLastIndex + 1L) {
            this.nextIndex = peerLastIndex + 1L;
        }
        this.free(peerLastIndex);
        this.fullElapsedTick = -1;
        return this;
    }

    @Override
    public PeerLogReplicatorState replicateTo(long endIndex) {
        assert (endIndex + 1L >= this.nextIndex);
        boolean isHeartbeat = endIndex == Math.max(this.nextIndex, this.stateStorage.firstIndex()) - 1L;
        this.unconfirmedHeartbeatTick = isHeartbeat ? this.unconfirmedHeartbeatTick + this.heartbeatElapsedTick : 0;
        this.heartbeatElapsedTick = 0;
        this.needHeartbeat = false;
        this.nextIndex = endIndex + 1L;
        this.inflightAppends.add(endIndex);
        if (this.isFull() && this.fullElapsedTick == -1) {
            this.fullElapsedTick = 0;
        }
        return this;
    }

    void free(long belowIndex) {
        while (!this.inflightAppends.isEmpty() && this.inflightAppends.peekFirst() <= belowIndex) {
            this.inflightAppends.removeFirst();
        }
        if (this.inflightAppends.isEmpty()) {
            this.unconfirmedHeartbeatTick = 0;
        }
    }

    boolean isFull() {
        return this.inflightAppends.size() >= this.config.getMaxInflightAppends();
    }
}

