/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

public enum StatisticsUsageState {
    OFF(0),
    NO_UPDATE(1),
    ON(2);

    private final int idx;
    private static final StatisticsUsageState[] VALS;

    private StatisticsUsageState(int idx) {
        this.idx = idx;
    }

    public int index() {
        return this.idx;
    }

    public static StatisticsUsageState fromOrdinal(int ord) {
        return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
    }

    public StatisticsUsageState fromString(String val) {
        switch (val) {
            case "OFF": {
                return OFF;
            }
            case "NO_UPDATE": {
                return NO_UPDATE;
            }
            case "ON": {
                return ON;
            }
        }
        throw new IllegalArgumentException(val);
    }

    static {
        StatisticsUsageState[] statisticsUsageStates = StatisticsUsageState.values();
        int maxIdx = 0;
        for (StatisticsUsageState recordType : statisticsUsageStates) {
            maxIdx = Math.max(maxIdx, recordType.idx);
        }
        VALS = new StatisticsUsageState[maxIdx + 1];
        StatisticsUsageState[] statisticsUsageStateArray = statisticsUsageStates;
        int n = statisticsUsageStateArray.length;
        for (int i = 0; i < n; ++i) {
            StatisticsUsageState plcType;
            StatisticsUsageState.VALS[plcType.idx] = plcType = statisticsUsageStateArray[i];
        }
    }
}

