/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.raft.handlers;

import java.util.function.IntFunction;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.partition.replicator.network.command.WriteIntentSwitchCommand;
import org.apache.ignite.internal.partition.replicator.network.command.WriteIntentSwitchCommandV2;
import org.apache.ignite.internal.partition.replicator.raft.CommandResult;
import org.apache.ignite.internal.partition.replicator.raft.RaftTableProcessor;
import org.apache.ignite.internal.partition.replicator.raft.RaftTxFinishMarker;
import org.apache.ignite.internal.partition.replicator.raft.handlers.AbstractCommandHandler;
import org.apache.ignite.internal.raft.WriteCommand;
import org.apache.ignite.internal.tx.TxManager;
import org.jetbrains.annotations.Nullable;

public class WriteIntentSwitchCommandHandler
extends AbstractCommandHandler<WriteIntentSwitchCommand> {
    private static final IgniteLogger LOG = Loggers.forClass(WriteIntentSwitchCommandHandler.class);
    private final IntFunction<RaftTableProcessor> tableProcessorByTableId;
    private final RaftTxFinishMarker txFinishMarker;

    public WriteIntentSwitchCommandHandler(IntFunction<RaftTableProcessor> tableProcessorByTableId, TxManager txManager) {
        this.tableProcessorByTableId = tableProcessorByTableId;
        this.txFinishMarker = new RaftTxFinishMarker(txManager);
    }

    @Override
    protected CommandResult handleInternally(WriteIntentSwitchCommand switchCommand, long commandIndex, long commandTerm, @Nullable HybridTimestamp safeTimestamp) {
        assert (switchCommand instanceof WriteIntentSwitchCommandV2) : "Unexpected command type: " + String.valueOf(switchCommand.getClass());
        this.txFinishMarker.markFinished(switchCommand.txId(), switchCommand.commit(), switchCommand.commitTimestamp(), null);
        boolean applied = false;
        for (int tableId : ((WriteIntentSwitchCommandV2)switchCommand).tableIds()) {
            RaftTableProcessor tableProcessor = this.raftTableProcessor(tableId);
            if (tableProcessor == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Table processor for table ID {} not found. Command execution for the table will be ignored: {}", new Object[]{tableId, switchCommand.toStringForLightLogging()});
                continue;
            }
            CommandResult singleResult = tableProcessor.processCommand((WriteCommand)switchCommand, commandIndex, commandTerm, safeTimestamp);
            applied = applied || singleResult.wasApplied();
        }
        return new CommandResult(null, applied);
    }

    @Nullable
    private RaftTableProcessor raftTableProcessor(int tableId) {
        return this.tableProcessorByTableId.apply(tableId);
    }
}

