/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.schema.BinaryTupleComparator;
import org.apache.ignite.internal.schema.PartialBinaryTupleMatcher;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageClosedException;
import org.apache.ignite.internal.storage.StorageDestroyedException;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.StorageRebalanceException;
import org.apache.ignite.internal.storage.index.IndexNotBuiltException;
import org.apache.ignite.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite.internal.storage.util.StorageState;
import org.apache.ignite.internal.type.NativeType;
import org.jetbrains.annotations.Nullable;

public class StorageUtils {
    public static String createMissingMvPartitionErrorMessage(int partitionId) {
        return "Partition ID " + partitionId + " does not exist";
    }

    public static void throwExceptionIfStorageNotInRunnableState(StorageState state, Supplier<String> storageInfoSupplier) {
        if (state != StorageState.RUNNABLE) {
            StorageUtils.throwExceptionDependingOnStorageState(state, storageInfoSupplier.get());
        }
    }

    public static void throwExceptionIfStorageNotInRunnableOrRebalanceState(StorageState state, Supplier<String> storageInfoSupplier) {
        if (state != StorageState.RUNNABLE && state != StorageState.REBALANCE) {
            StorageUtils.throwExceptionDependingOnStorageState(state, storageInfoSupplier.get());
        }
    }

    public static void throwExceptionIfStorageNotInCleanupOrRebalancedState(StorageState state, Supplier<String> storageInfoSupplier) {
        if (state != StorageState.CLEANUP && state != StorageState.REBALANCE) {
            StorageUtils.throwExceptionDependingOnStorageState(state, storageInfoSupplier.get());
        }
    }

    public static void throwExceptionIfStorageInProgressOfRebalance(StorageState state, Supplier<String> storageInfoSupplier) {
        if (state == StorageState.REBALANCE) {
            throw new StorageRebalanceException(StorageUtils.createStorageInProcessOfRebalanceErrorMessage(storageInfoSupplier.get()));
        }
    }

    public static void throwExceptionDependingOnStorageStateOnRebalance(StorageState state, String storageInfo) {
        switch (state) {
            case CLOSED: {
                throw new StorageRebalanceException(StorageUtils.createStorageClosedErrorMessage(storageInfo));
            }
            case REBALANCE: {
                throw new StorageRebalanceException(StorageUtils.createStorageInProcessOfRebalanceErrorMessage(storageInfo));
            }
            case CLEANUP: {
                throw new StorageRebalanceException(StorageUtils.createStorageInProcessOfCleanupErrorMessage(storageInfo));
            }
            case DESTROYED: {
                throw new StorageRebalanceException(StorageUtils.createStorageDestroyedErrorMessage(storageInfo));
            }
        }
        throw new StorageRebalanceException(StorageUtils.createUnexpectedStorageStateErrorMessage(state, storageInfo));
    }

    public static void throwExceptionDependingOnStorageState(StorageState state, String storageInfo) {
        switch (state) {
            case CLOSED: {
                throw new StorageClosedException(StorageUtils.createStorageClosedErrorMessage(storageInfo));
            }
            case REBALANCE: {
                throw new StorageRebalanceException(StorageUtils.createStorageInProcessOfRebalanceErrorMessage(storageInfo));
            }
            case CLEANUP: {
                throw new StorageException(StorageUtils.createStorageInProcessOfCleanupErrorMessage(storageInfo));
            }
            case DESTROYED: {
                throw new StorageDestroyedException(StorageUtils.createStorageDestroyedErrorMessage(storageInfo));
            }
        }
        throw new StorageException(StorageUtils.createUnexpectedStorageStateErrorMessage(state, storageInfo));
    }

    public static void throwExceptionDependingOnIndexStorageState(StorageState state, boolean read, String storageInfo) {
        switch (state) {
            case CLOSED: {
                throw new StorageClosedException(StorageUtils.createStorageClosedErrorMessage(storageInfo));
            }
            case REBALANCE: {
                throw new StorageRebalanceException(StorageUtils.createStorageInProcessOfRebalanceErrorMessage(storageInfo));
            }
            case CLEANUP: {
                throw new StorageException(StorageUtils.createStorageInProcessOfCleanupErrorMessage(storageInfo));
            }
            case DESTROYED: {
                if (read) {
                    throw new StorageDestroyedException(IgniteStringFormatter.format((String)"Read from an index storage that is in the process of being destroyed or already destroyed: [{}]", (Object[])new Object[]{storageInfo}));
                }
                throw new StorageDestroyedException(StorageUtils.createStorageDestroyedErrorMessage(storageInfo));
            }
        }
        throw new StorageException(StorageUtils.createUnexpectedStorageStateErrorMessage(state, storageInfo));
    }

    public static void throwExceptionIfStorageNotInProgressOfRebalance(StorageState state, Supplier<String> storageInfoSupplier) {
        if (state != StorageState.REBALANCE) {
            throw new StorageRebalanceException(StorageUtils.createStorageInProcessOfRebalanceErrorMessage(storageInfoSupplier.get()));
        }
    }

    public static void throwStorageExceptionIfItCause(IgniteInternalCheckedException e) {
        if (e.getCause() instanceof StorageException) {
            throw (StorageException)((Object)e.getCause());
        }
    }

    private static String createStorageInProcessOfRebalanceErrorMessage(String storageInfo) {
        return IgniteStringFormatter.format((String)"Storage in the process of rebalancing: [{}]", (Object[])new Object[]{storageInfo});
    }

    private static String createUnexpectedStorageStateErrorMessage(StorageState state, String storageInfo) {
        return IgniteStringFormatter.format((String)"Unexpected state: [{}, state={}]", (Object[])new Object[]{storageInfo, state});
    }

    private static String createStorageClosedErrorMessage(String storageInfo) {
        return IgniteStringFormatter.format((String)"Storage is already closed: [{}]", (Object[])new Object[]{storageInfo});
    }

    private static String createStorageInProcessOfCleanupErrorMessage(String storageInfo) {
        return IgniteStringFormatter.format((String)"Storage is in the process of cleanup: [{}]", (Object[])new Object[]{storageInfo});
    }

    private static String createStorageDestroyedErrorMessage(String storageInfo) {
        return IgniteStringFormatter.format((String)"Storage is in the process of being destroyed or already destroyed: [{}]", (Object[])new Object[]{storageInfo});
    }

    public static boolean transitionToDestroyedState(AtomicReference<StorageState> stateRef) {
        StorageState previous;
        do {
            if (!(previous = stateRef.get()).isTerminal()) continue;
            return false;
        } while (!stateRef.compareAndSet(previous, StorageState.DESTROYED));
        return true;
    }

    public static boolean transitionToClosedState(AtomicReference<StorageState> stateRef, Supplier<String> errorMsgSupplier) {
        StorageState prevState = stateRef.compareAndExchange(StorageState.RUNNABLE, StorageState.CLOSED);
        if (prevState.isTerminal()) {
            return false;
        }
        if (prevState != StorageState.RUNNABLE) {
            StorageUtils.throwExceptionDependingOnStorageState(prevState, errorMsgSupplier.get());
        }
        return true;
    }

    public static RowId initialRowIdToBuild(int partitionId) {
        return RowId.lowestRowId(partitionId);
    }

    public static void throwExceptionIfIndexIsNotBuilt(@Nullable RowId nextRowIdToBuild, Supplier<String> storageInfoSupplier) {
        if (nextRowIdToBuild != null) {
            throw new IndexNotBuiltException("Index not built yet: [{}]", storageInfoSupplier.get());
        }
    }

    public static BinaryTupleComparator binaryTupleComparator(List<StorageSortedIndexDescriptor.StorageSortedIndexColumnDescriptor> columns) {
        ArrayList<CatalogColumnCollation> columnCollation = new ArrayList<CatalogColumnCollation>(columns.size());
        ArrayList<NativeType> columnTypes = new ArrayList<NativeType>(columns.size());
        for (StorageSortedIndexDescriptor.StorageSortedIndexColumnDescriptor col : columns) {
            columnCollation.add(CatalogColumnCollation.get((boolean)col.asc(), (boolean)col.nullsFirst()));
            columnTypes.add(col.type());
        }
        return new BinaryTupleComparator(columnCollation, columnTypes);
    }

    public static PartialBinaryTupleMatcher partialBinaryTupleComparator(List<StorageSortedIndexDescriptor.StorageSortedIndexColumnDescriptor> columns) {
        ArrayList<CatalogColumnCollation> columnCollation = new ArrayList<CatalogColumnCollation>(columns.size());
        ArrayList<NativeType> columnTypes = new ArrayList<NativeType>(columns.size());
        for (StorageSortedIndexDescriptor.StorageSortedIndexColumnDescriptor col : columns) {
            columnCollation.add(CatalogColumnCollation.get((boolean)col.asc(), (boolean)col.nullsFirst()));
            columnTypes.add(col.type());
        }
        return new PartialBinaryTupleMatcher(columnCollation, columnTypes);
    }
}

