/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.subscriber.CompletionAwareSubscriber;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.NonBlockingBodyArgumentBinder;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyHttpServer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.EmptyByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

@Internal
public class InputStreamBodyBinder
implements NonBlockingBodyArgumentBinder<InputStream> {
    public static final Argument<InputStream> TYPE = Argument.of(InputStream.class);
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpServer.class);
    private final HttpContentProcessorResolver processorResolver;
    private final ExecutorService executorService;

    public InputStreamBodyBinder(HttpContentProcessorResolver processorResolver, ExecutorService executorService) {
        this.processorResolver = processorResolver;
        this.executorService = executorService;
    }

    public Argument<InputStream> argumentType() {
        return TYPE;
    }

    public ArgumentBinder.BindingResult<InputStream> bind(final ArgumentConversionContext<InputStream> context, HttpRequest<?> source) {
        NettyHttpRequest nettyHttpRequest;
        io.netty.handler.codec.http.HttpRequest nativeRequest;
        if (source instanceof NettyHttpRequest && (nativeRequest = (nettyHttpRequest = (NettyHttpRequest)source).getNativeRequest()) instanceof StreamedHttpRequest) {
            final PipedOutputStream outputStream = new PipedOutputStream();
            try {
                PipedInputStream inputStream = new PipedInputStream(outputStream){
                    private volatile HttpContentProcessor<ByteBufHolder> processor;

                    private synchronized void init() {
                        if (this.processor == null) {
                            this.processor = InputStreamBodyBinder.this.processorResolver.resolve(nettyHttpRequest, context.getArgument());
                            Flux.from(this.processor).publishOn(Schedulers.fromExecutor((Executor)InputStreamBodyBinder.this.executorService)).subscribe((Subscriber)new CompletionAwareSubscriber<ByteBufHolder>(){

                                protected void doOnSubscribe(Subscription subscription) {
                                    subscription.request(1L);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                protected synchronized void doOnNext(ByteBufHolder message) {
                                    ByteBuf content;
                                    if (LOG.isTraceEnabled()) {
                                        LOG.trace("Server received streaming message for argument [{}]: {}", (Object)context.getArgument(), (Object)message);
                                    }
                                    if (!((content = message.content()) instanceof EmptyByteBuf)) {
                                        try {
                                            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)content);
                                            outputStream.write(bytes, 0, bytes.length);
                                        }
                                        catch (IOException e) {
                                            this.subscription.cancel();
                                            return;
                                        }
                                        finally {
                                            content.release();
                                        }
                                    }
                                    this.subscription.request(1L);
                                }

                                protected synchronized void doOnError(Throwable t) {
                                    if (LOG.isTraceEnabled()) {
                                        LOG.trace("Server received error for argument [" + context.getArgument() + "]: " + t.getMessage(), t);
                                    }
                                    try {
                                        outputStream.close();
                                    }
                                    catch (IOException iOException) {
                                    }
                                    finally {
                                        this.subscription.cancel();
                                    }
                                }

                                protected synchronized void doOnComplete() {
                                    if (LOG.isTraceEnabled()) {
                                        LOG.trace("Done receiving messages for argument: {}", (Object)context.getArgument());
                                    }
                                    try {
                                        outputStream.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            });
                        }
                    }

                    @Override
                    public synchronized int read(byte[] b, int off, int len) throws IOException {
                        this.init();
                        return super.read(b, off, len);
                    }

                    @Override
                    public synchronized int read() throws IOException {
                        this.init();
                        return super.read();
                    }
                };
                return () -> Optional.of(inputStream);
            }
            catch (IOException e) {
                context.reject((Exception)e);
            }
        }
        return ArgumentBinder.BindingResult.EMPTY;
    }
}

