/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class QueuePath
implements Iterable<String> {
    private static final String QUEUE_REGEX_DELIMITER = "\\.";
    private String parent;
    private String leaf;

    public QueuePath(String parent, String leaf) {
        this.parent = parent;
        this.leaf = leaf;
    }

    public QueuePath(String fullPath) {
        this.setFromFullPath(fullPath);
    }

    public static QueuePath createFromQueues(String ... parts) {
        return new QueuePath(String.join((CharSequence)".", parts));
    }

    private void setFromFullPath(String fullPath) {
        this.parent = null;
        this.leaf = fullPath;
        if (this.leaf == null) {
            this.leaf = "";
            return;
        }
        int lastDotIdx = fullPath.lastIndexOf(".");
        if (lastDotIdx > -1) {
            this.parent = fullPath.substring(0, lastDotIdx).trim();
            this.leaf = fullPath.substring(lastDotIdx + 1).trim();
        }
    }

    public boolean hasEmptyPart() {
        if (this.leaf.isEmpty()) {
            return true;
        }
        for (String part : this) {
            if (!part.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getParent() {
        return this.parent;
    }

    public String getLeafName() {
        return this.leaf;
    }

    public String getFullPath() {
        return this.hasParent() ? this.parent + "." + this.leaf : this.leaf;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isRoot() {
        return !this.hasParent() && this.leaf.equals("root");
    }

    public QueuePath createNewLeaf(String childQueue) {
        return new QueuePath(this.getFullPath(), childQueue);
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.asList(this.getFullPath().split(QUEUE_REGEX_DELIMITER)).iterator();
    }

    public Iterator<String> reverseIterator() {
        return new Iterator<String>(){
            private String current;
            {
                this.current = QueuePath.this.getFullPath();
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int parentQueueNameEndIndex = this.current.lastIndexOf(".");
                String old = this.current;
                this.current = parentQueueNameEndIndex > -1 ? this.current.substring(0, parentQueueNameEndIndex).trim() : null;
                return old;
            }
        };
    }

    public String toString() {
        return this.getFullPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueuePath other = (QueuePath)o;
        return Objects.equals(this.parent, other.parent) && Objects.equals(this.leaf, other.leaf);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.leaf);
    }
}

