/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterFailoverWithProceduresTestBase;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestCreateTableWithMasterFailover
extends MasterFailoverWithProceduresTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCreateTableWithMasterFailover.class);

    @Test
    public void testCreateWithFailover() throws Exception {
        this.testCreateWithFailoverAtStep(MasterProcedureProtos.CreateTableState.CREATE_TABLE_ASSIGN_REGIONS.ordinal());
    }

    private void testCreateWithFailoverAtStep(int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testCreateWithFailoverAtStep" + step));
        ProcedureExecutor<MasterProcedureEnv> procExec = TestCreateTableWithMasterFailover.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillBeforeStoreUpdate(procExec, (boolean)true);
        ProcedureTestingUtility.setToggleKillBeforeStoreUpdate(procExec, (boolean)true);
        byte[][] splitKeys = null;
        TableDescriptor htd = MasterProcedureTestingUtility.createHTD(tableName, "f1", "f2");
        RegionInfo[] regions = ModifyRegionUtils.createRegionInfos((TableDescriptor)htd, (byte[][])splitKeys);
        long procId = procExec.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions));
        TestCreateTableWithMasterFailover.testRecoveryAndDoubleExecution(UTIL, procId, step);
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f1", "f2");
    }
}

