/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcDeniedReply;
import org.apache.hadoop.oncrpc.RpcInfo;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.RpcResponse;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.apache.hadoop.oncrpc.SimpleUdpClient;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.apache.hadoop.portmap.PortmapMapping;
import org.apache.hadoop.portmap.PortmapRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcProgram
extends ChannelInboundHandlerAdapter {
    static final Logger LOG = LoggerFactory.getLogger(RpcProgram.class);
    public static final int RPCB_PORT = 111;
    private final String program;
    private final String host;
    private int port;
    private final int progNumber;
    private final int lowProgVersion;
    private final int highProgVersion;
    protected final boolean allowInsecurePorts;
    private final DatagramSocket registrationSocket;
    private final int portmapUdpTimeoutMillis;

    protected RpcProgram(String program, String host, int port, int progNumber, int lowProgVersion, int highProgVersion, DatagramSocket registrationSocket, boolean allowInsecurePorts) {
        this(program, host, port, progNumber, lowProgVersion, highProgVersion, registrationSocket, allowInsecurePorts, 500);
    }

    protected RpcProgram(String program, String host, int port, int progNumber, int lowProgVersion, int highProgVersion, DatagramSocket registrationSocket, boolean allowInsecurePorts, int portmapUdpTimeoutMillis) {
        this.program = program;
        this.host = host;
        this.port = port;
        this.progNumber = progNumber;
        this.lowProgVersion = lowProgVersion;
        this.highProgVersion = highProgVersion;
        this.registrationSocket = registrationSocket;
        this.allowInsecurePorts = allowInsecurePorts;
        this.portmapUdpTimeoutMillis = portmapUdpTimeoutMillis;
        LOG.info("Will " + (allowInsecurePorts ? "" : "not ") + "accept client connections from unprivileged ports");
    }

    public void register(int transport, int boundPort) {
        if (boundPort != this.port) {
            LOG.info("The bound port is " + boundPort + ", different with configured port " + this.port);
            this.port = boundPort;
        }
        for (int vers = this.lowProgVersion; vers <= this.highProgVersion; ++vers) {
            PortmapMapping mapEntry = new PortmapMapping(this.progNumber, vers, transport, this.port);
            this.register(mapEntry, true);
        }
    }

    public void unregister(int transport, int boundPort) {
        if (boundPort != this.port) {
            LOG.info("The bound port is " + boundPort + ", different with configured port " + this.port);
            this.port = boundPort;
        }
        for (int vers = this.lowProgVersion; vers <= this.highProgVersion; ++vers) {
            PortmapMapping mapEntry = new PortmapMapping(this.progNumber, vers, transport, this.port);
            this.register(mapEntry, false);
        }
    }

    protected void register(PortmapMapping mapEntry, boolean set) {
        XDR mappingRequest = PortmapRequest.create(mapEntry, set);
        SimpleUdpClient registrationClient = new SimpleUdpClient(this.host, 111, mappingRequest, true, this.registrationSocket, this.portmapUdpTimeoutMillis);
        try {
            registrationClient.run();
        }
        catch (IOException e) {
            String request = set ? "Registration" : "Unregistration";
            LOG.error(request + " failure with " + this.host + ":" + this.port + ", portmap entry: " + mapEntry);
            throw new RuntimeException(request + " failure", e);
        }
    }

    public void startDaemons() {
    }

    public void stopDaemons() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        RpcInfo info = (RpcInfo)msg;
        try {
            this.channelRead(ctx, info);
        }
        finally {
            ReferenceCountUtil.release((Object)info.data());
        }
    }

    private void channelRead(ChannelHandlerContext ctx, RpcInfo info) throws Exception {
        RpcCall call = (RpcCall)info.header();
        SocketAddress remoteAddress = info.remoteAddress();
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.program + " procedure #" + call.getProcedure());
        }
        if (this.progNumber != call.getProgram()) {
            LOG.warn("Invalid RPC call program " + call.getProgram());
            this.sendAcceptedReply(call, remoteAddress, RpcAcceptedReply.AcceptState.PROG_UNAVAIL, ctx);
            return;
        }
        int ver = call.getVersion();
        if (ver < this.lowProgVersion || ver > this.highProgVersion) {
            LOG.warn("Invalid RPC call version " + ver);
            this.sendAcceptedReply(call, remoteAddress, RpcAcceptedReply.AcceptState.PROG_MISMATCH, ctx);
            return;
        }
        this.handleInternal(ctx, info);
    }

    public boolean doPortMonitoring(SocketAddress remoteAddress) {
        if (!this.allowInsecurePorts) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Will not allow connections from unprivileged ports. Checking for valid client port...");
            }
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress inetRemoteAddress = (InetSocketAddress)remoteAddress;
                if (inetRemoteAddress.getPort() > 1023) {
                    LOG.warn("Connection attempted from '" + inetRemoteAddress + "' which is an unprivileged port. Rejecting connection.");
                    return false;
                }
            } else {
                LOG.warn("Could not determine remote port of socket address '" + remoteAddress + "'. Rejecting connection.");
                return false;
            }
        }
        return true;
    }

    private void sendAcceptedReply(RpcCall call, SocketAddress remoteAddress, RpcAcceptedReply.AcceptState acceptState, ChannelHandlerContext ctx) {
        RpcAcceptedReply reply = RpcAcceptedReply.getInstance(call.getXid(), acceptState, VerifierNone.INSTANCE);
        XDR out = new XDR();
        reply.write(out);
        if (acceptState == RpcAcceptedReply.AcceptState.PROG_MISMATCH) {
            out.writeInt(this.lowProgVersion);
            out.writeInt(this.highProgVersion);
        }
        ByteBuf b = Unpooled.wrappedBuffer((ByteBuffer)out.asReadOnlyWrap().buffer());
        RpcResponse rsp = new RpcResponse(b, remoteAddress);
        RpcUtil.sendRpcResponse(ctx, rsp);
    }

    protected static void sendRejectedReply(RpcCall call, SocketAddress remoteAddress, ChannelHandlerContext ctx) {
        XDR out = new XDR();
        RpcDeniedReply reply = new RpcDeniedReply(call.getXid(), RpcReply.ReplyState.MSG_DENIED, RpcDeniedReply.RejectState.AUTH_ERROR, new VerifierNone());
        reply.write(out);
        ByteBuf buf = Unpooled.wrappedBuffer((ByteBuffer)out.asReadOnlyWrap().buffer());
        RpcResponse rsp = new RpcResponse(buf, remoteAddress);
        RpcUtil.sendRpcResponse(ctx, rsp);
    }

    protected abstract void handleInternal(ChannelHandlerContext var1, RpcInfo var2);

    public String toString() {
        return "Rpc program: " + this.program + " at " + this.host + ":" + this.port;
    }

    protected abstract boolean isIdempotent(RpcCall var1);

    public int getPort() {
        return this.port;
    }

    @VisibleForTesting
    public int getPortmapUdpTimeoutMillis() {
        return this.portmapUdpTimeoutMillis;
    }
}

