/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.matrix.decomposition.LDLDecomposition;
import org.ojalgo.matrix.decomposition.LDU;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.RawLDL;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

public interface LDL<N extends Number>
extends LDU<N>,
MatrixDecomposition.Hermitian<N> {
    public static final Factory<BigDecimal> BIG = typical -> new LDLDecomposition.Big();
    public static final Factory<ComplexNumber> COMPLEX = typical -> new LDLDecomposition.Complex();
    public static final Factory<Double> PRIMITIVE = typical -> {
        if (256L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
            return new LDLDecomposition.Primitive();
        }
        return new RawLDL();
    };

    public static <N extends Number> LDL<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return (LDL)BIG.make(typical);
        }
        if (tmpNumber instanceof ComplexNumber) {
            return (LDL)COMPLEX.make(typical);
        }
        if (tmpNumber instanceof Double) {
            return (LDL)PRIMITIVE.make(typical);
        }
        throw new IllegalArgumentException();
    }

    public static <N extends Number> boolean equals(MatrixStore<N> matrix, LDL<N> decomposition, NumberContext context) {
        return AccessUtils.equals(matrix, decomposition.reconstruct(), context);
    }

    public static <N extends Number> MatrixStore<N> reconstruct(LDL<N> decomposition) {
        MatrixStore<MatrixStore<N>> tmpL = decomposition.getL();
        MatrixStore<N> tmpD = decomposition.getD();
        MatrixStore<N> tmpR = decomposition.getR();
        return tmpL.multiply(tmpD).multiply((MatrixStore<MatrixStore<N>>)tmpR);
    }

    default public boolean equals(MatrixStore<N> other, NumberContext context) {
        return LDL.equals(other, this, context);
    }

    public MatrixStore<N> getD();

    default public MatrixStore<N> getL() {
        return this.getR().conjugate();
    }

    default public MatrixStore<N> getR() {
        return this.getL().conjugate();
    }

    public int getRank();

    default public boolean isFullSize() {
        return true;
    }

    public boolean isSquareAndNotSingular();

    @Override
    default public MatrixStore<N> reconstruct() {
        return LDL.reconstruct(this);
    }

    public static interface Factory<N extends Number>
    extends MatrixDecomposition.Factory<LDL<N>> {
    }
}

