/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.matrix.decomposition.CholeskyDecomposition;
import org.ojalgo.matrix.decomposition.LDU;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.RawCholesky;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

public interface Cholesky<N extends Number>
extends LDU<N>,
MatrixDecomposition.Hermitian<N> {
    public static final Factory<BigDecimal> BIG = typical -> new CholeskyDecomposition.Big();
    public static final Factory<ComplexNumber> COMPLEX = typical -> new CholeskyDecomposition.Complex();
    public static final Factory<Double> PRIMITIVE = typical -> {
        if (32L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
            return new CholeskyDecomposition.Primitive();
        }
        return new RawCholesky();
    };

    public static <N extends Number> Cholesky<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return (Cholesky)BIG.make(typical);
        }
        if (tmpNumber instanceof ComplexNumber) {
            return (Cholesky)COMPLEX.make(typical);
        }
        if (tmpNumber instanceof Double) {
            return (Cholesky)PRIMITIVE.make(typical);
        }
        throw new IllegalArgumentException();
    }

    public static <N extends Number> boolean equals(MatrixStore<N> matrix, Cholesky<N> decomposition, NumberContext context) {
        boolean retVal = false;
        MatrixStore<Object> tmpL = decomposition.getL();
        retVal = AccessUtils.equals(tmpL.multiply(tmpL.logical().conjugate().get()), matrix, context);
        return retVal;
    }

    public static <N extends Number> MatrixStore<N> reconstruct(Cholesky<N> decomposition) {
        MatrixStore<Object> tmpL = decomposition.getL();
        return tmpL.multiply(tmpL.conjugate());
    }

    public boolean isSPD();

    default public MatrixStore<N> getL() {
        return this.getR().conjugate();
    }

    default public MatrixStore<N> getR() {
        return this.getL().conjugate();
    }

    @Override
    default public MatrixStore<N> reconstruct() {
        return Cholesky.reconstruct(this);
    }

    public static interface Factory<N extends Number>
    extends MatrixDecomposition.Factory<Cholesky<N>> {
    }
}

