/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import org.apache.hadoop.ipc.RetryCache;
import org.apache.hadoop.ipc.metrics.RetryCacheMetrics;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRetryCacheMetrics {
    static final String cacheName = "NameNodeRetryCache";

    @Test
    public void testNames() {
        RetryCache cache = (RetryCache)Mockito.mock(RetryCache.class);
        Mockito.when((Object)cache.getCacheName()).thenReturn((Object)cacheName);
        RetryCacheMetrics metrics = RetryCacheMetrics.create((RetryCache)cache);
        metrics.incrCacheHit();
        metrics.incrCacheCleared();
        metrics.incrCacheCleared();
        metrics.incrCacheUpdated();
        metrics.incrCacheUpdated();
        metrics.incrCacheUpdated();
        this.checkMetrics(1L, 2L, 3L);
    }

    private void checkMetrics(long hit, long cleared, long updated) {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics("RetryCache.NameNodeRetryCache");
        MetricsAsserts.assertCounter("CacheHit", hit, rb);
        MetricsAsserts.assertCounter("CacheCleared", cleared, rb);
        MetricsAsserts.assertCounter("CacheUpdated", updated, rb);
    }
}

