/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.csi.translator;

import csi.v0.Csi;
import org.apache.hadoop.yarn.api.protocolrecords.GetPluginInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.NodePublishVolumeRequest;
import org.apache.hadoop.yarn.api.protocolrecords.NodeUnpublishVolumeRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesResponse;
import org.apache.hadoop.yarn.csi.translator.GetPluginInfoResponseProtoTranslator;
import org.apache.hadoop.yarn.csi.translator.NodePublishVolumeRequestProtoTranslator;
import org.apache.hadoop.yarn.csi.translator.NodeUnpublishVolumeRequestProtoTranslator;
import org.apache.hadoop.yarn.csi.translator.ProtoTranslator;
import org.apache.hadoop.yarn.csi.translator.ValidateVolumeCapabilitiesRequestProtoTranslator;
import org.apache.hadoop.yarn.csi.translator.ValidationVolumeCapabilitiesResponseProtoTranslator;

public final class ProtoTranslatorFactory {
    private ProtoTranslatorFactory() {
    }

    public static <A, B> ProtoTranslator<A, B> getTranslator(Class<A> yarnProto, Class<B> csiProto) {
        if (yarnProto == ValidateVolumeCapabilitiesRequest.class && csiProto == Csi.ValidateVolumeCapabilitiesRequest.class) {
            return new ValidateVolumeCapabilitiesRequestProtoTranslator();
        }
        if (yarnProto == ValidateVolumeCapabilitiesResponse.class && csiProto == Csi.ValidateVolumeCapabilitiesResponse.class) {
            return new ValidationVolumeCapabilitiesResponseProtoTranslator();
        }
        if (yarnProto == NodePublishVolumeRequest.class && csiProto == Csi.NodePublishVolumeRequest.class) {
            return new NodePublishVolumeRequestProtoTranslator();
        }
        if (yarnProto == GetPluginInfoResponse.class && csiProto == Csi.GetPluginInfoResponse.class) {
            return new GetPluginInfoResponseProtoTranslator();
        }
        if (yarnProto == NodeUnpublishVolumeRequest.class && csiProto == Csi.NodeUnpublishVolumeRequest.class) {
            return new NodeUnpublishVolumeRequestProtoTranslator();
        }
        throw new IllegalArgumentException("A problem is found while processing proto message translating. Unexpected message types, no transformer is found can handle the transformation from type " + yarnProto.getName() + " <-> " + csiProto.getName());
    }
}

