/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.DocumentCollection;
import com.microsoft.azure.cosmosdb.ISessionContainer;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxClientCollectionCache;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Single;

public class RenameCollectionAwareClientRetryPolicy
implements IDocumentClientRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(RenameCollectionAwareClientRetryPolicy.class);
    private final IDocumentClientRetryPolicy retryPolicy;
    private final ISessionContainer sessionContainer;
    private final RxClientCollectionCache collectionCache;
    private RxDocumentServiceRequest request;
    private boolean hasTriggered = false;

    public RenameCollectionAwareClientRetryPolicy(ISessionContainer sessionContainer, RxClientCollectionCache collectionCache, IDocumentClientRetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        this.sessionContainer = sessionContainer;
        this.collectionCache = collectionCache;
        this.request = null;
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.request = request;
        this.retryPolicy.onBeforeSendRequest(request);
    }

    @Override
    public Single<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception e) {
        return this.retryPolicy.shouldRetry(e).flatMap(shouldRetryResult -> {
            if (!shouldRetryResult.shouldRetry && !this.hasTriggered) {
                DocumentClientException clientException = (DocumentClientException)((Object)((Object)Utils.as((Object)e, DocumentClientException.class)));
                if (this.request == null) {
                    logger.error("onBeforeSendRequest is not invoked, encountered failure due to request being null", (Throwable)e);
                    return Single.just((Object)IRetryPolicy.ShouldRetryResult.error(e));
                }
                if (clientException != null && this.request.getIsNameBased() && Exceptions.isStatusCode((DocumentClientException)clientException, (int)404) && Exceptions.isSubStatusCode((DocumentClientException)clientException, (int)1002)) {
                    logger.warn("Clear the token for named base request {}", (Object)this.request.getResourceAddress());
                    this.sessionContainer.clearTokenByCollectionFullName(this.request.getResourceAddress());
                    this.hasTriggered = true;
                    String oldCollectionRid = this.request.requestContext.resolvedCollectionRid;
                    this.request.forceNameCacheRefresh = true;
                    this.request.requestContext.resolvedCollectionRid = null;
                    Single<DocumentCollection> collectionObs = this.collectionCache.resolveCollectionAsync(this.request);
                    return collectionObs.flatMap(collectionInfo -> {
                        if (collectionInfo == null) {
                            logger.warn("Can't recover from session unavailable exception because resolving collection name {} returned null", (Object)this.request.getResourceAddress());
                        } else if (!StringUtils.isEmpty((CharSequence)oldCollectionRid) && !StringUtils.isEmpty((CharSequence)collectionInfo.getResourceId())) {
                            return Single.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(Duration.ZERO));
                        }
                        return Single.just((Object)shouldRetryResult);
                    }).onErrorResumeNext(throwable -> {
                        logger.warn("Can't recover from session unavailable exception because resolving collection name {} failed with {}", (Object)this.request.getResourceAddress(), (Object)throwable.getMessage());
                        if (throwable instanceof Exception) {
                            return Single.just((Object)IRetryPolicy.ShouldRetryResult.error((Exception)throwable));
                        }
                        return Single.error((Throwable)throwable);
                    });
                }
            }
            return Single.just((Object)shouldRetryResult);
        });
    }
}

