/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.server.router.RouterServerUtil;
import org.apache.hadoop.yarn.server.router.clientrm.RouterClientRMService;
import org.apache.hadoop.yarn.server.router.webapp.RESTRequestInterceptor;

public abstract class AbstractRESTRequestInterceptor
implements RESTRequestInterceptor {
    private Configuration conf;
    private RESTRequestInterceptor nextInterceptor;
    private UserGroupInformation user = null;
    private RouterClientRMService routerClientRMService = null;

    @Override
    public void setNextInterceptor(RESTRequestInterceptor nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        if (this.nextInterceptor != null) {
            this.nextInterceptor.setConf(conf);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void init(String userName) {
        this.user = RouterServerUtil.setupUser(userName);
        if (this.nextInterceptor != null) {
            this.nextInterceptor.init(userName);
        }
    }

    @Override
    public void shutdown() {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.shutdown();
        }
    }

    @Override
    public RESTRequestInterceptor getNextInterceptor() {
        return this.nextInterceptor;
    }

    public UserGroupInformation getUser() {
        return this.user;
    }

    @Override
    public RouterClientRMService getRouterClientRMService() {
        return this.routerClientRMService;
    }

    @Override
    public void setRouterClientRMService(RouterClientRMService routerClientRMService) {
        this.routerClientRMService = routerClientRMService;
    }
}

