/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.jsonschema2pojo.rules;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hadoop.shaded.com.sun.codemodel.JAnnotationUse;
import org.apache.hadoop.shaded.com.sun.codemodel.JFieldVar;
import org.apache.hadoop.shaded.org.jsonschema2pojo.Schema;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.Rule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.RuleFactory;

public class MinimumMaximumRule
implements Rule<JFieldVar, JFieldVar> {
    private final RuleFactory ruleFactory;

    protected MinimumMaximumRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JFieldVar apply(String nodeName, JsonNode node, JsonNode parent, JFieldVar field, Schema currentSchema) {
        if (this.ruleFactory.getGenerationConfig().isIncludeJsr303Annotations() && this.isApplicableType(field)) {
            JAnnotationUse annotation;
            if (node.has("minimum")) {
                annotation = field.annotate(DecimalMin.class);
                annotation.param("value", node.get("minimum").asText());
            }
            if (node.has("maximum")) {
                annotation = field.annotate(DecimalMax.class);
                annotation.param("value", node.get("maximum").asText());
            }
        }
        return field;
    }

    private boolean isApplicableType(JFieldVar field) {
        try {
            Class<?> fieldClass = Class.forName(field.type().boxify().fullName());
            return String.class.isAssignableFrom(fieldClass) || Number.class.isAssignableFrom(fieldClass) && !Float.class.isAssignableFrom(fieldClass) && !Double.class.isAssignableFrom(fieldClass);
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }
}

