/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.applications.mawo.server.master.job;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class JobId
implements Writable {
    private static final String JOB_PREFIX = "mawo_job_";
    private int jobIdentifier;

    static JobId newJobId() {
        Random rn = new Random();
        int range = 900000;
        int randomadd = 100000;
        int randomNum = rn.nextInt(900000) + 100000;
        return new JobId(randomNum);
    }

    public JobId() {
    }

    public JobId(int id) {
        this.jobIdentifier = id;
    }

    public final int getID() {
        return this.jobIdentifier;
    }

    public final String toString() {
        return JOB_PREFIX + this.jobIdentifier;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.jobIdentifier;
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobId other = (JobId)obj;
        return this.jobIdentifier == other.jobIdentifier;
    }

    public final void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.jobIdentifier);
    }

    public final void readFields(DataInput in) throws IOException {
        this.jobIdentifier = WritableUtils.readVInt((DataInput)in);
    }
}

