/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class BeginQuorumEpochResponse
extends AbstractResponse {
    private final BeginQuorumEpochResponseData data;

    public BeginQuorumEpochResponse(BeginQuorumEpochResponseData data) {
        super(ApiKeys.BEGIN_QUORUM_EPOCH);
        this.data = data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errors = new HashMap<Errors, Integer>();
        errors.put(Errors.forCode(this.data.errorCode()), 1);
        for (BeginQuorumEpochResponseData.TopicData topicResponse : this.data.topics()) {
            for (BeginQuorumEpochResponseData.PartitionData partitionResponse : topicResponse.partitions()) {
                errors.compute(Errors.forCode(partitionResponse.errorCode()), (error, count) -> count == null ? 1 : count + 1);
            }
        }
        return errors;
    }

    @Override
    public BeginQuorumEpochResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
    }

    public static BeginQuorumEpochResponse parse(ByteBuffer buffer, short version) {
        return new BeginQuorumEpochResponse(new BeginQuorumEpochResponseData(new ByteBufferAccessor(buffer), version));
    }
}

