/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j.tools;

import io.github.ollama4j.tools.ToolFunction;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public class ReflectionalToolFunction
implements ToolFunction {
    private Object functionHolder;
    private Method function;
    private LinkedHashMap<String, String> propertyDefinition;

    @Override
    public Object apply(Map<String, Object> arguments) {
        LinkedHashMap<String, String> argumentsCopy = new LinkedHashMap<String, String>(this.propertyDefinition);
        for (Map.Entry<String, String> param : this.propertyDefinition.entrySet()) {
            argumentsCopy.replace(param.getKey(), (String)this.typeCast(arguments.get(param.getKey()), param.getValue()));
        }
        try {
            return this.function.invoke(this.functionHolder, argumentsCopy.values().toArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke tool: " + this.function.getName(), e);
        }
    }

    private Object typeCast(Object inputValue, String className) {
        if (className == null || inputValue == null) {
            return null;
        }
        String inputValueString = inputValue.toString();
        switch (className) {
            case "java.lang.Integer": {
                return Integer.parseInt(inputValueString);
            }
            case "java.lang.Boolean": {
                return Boolean.valueOf(inputValueString);
            }
            case "java.math.BigDecimal": {
                return new BigDecimal(inputValueString);
            }
        }
        return inputValueString;
    }

    @Generated
    public void setFunctionHolder(Object functionHolder) {
        this.functionHolder = functionHolder;
    }

    @Generated
    public void setFunction(Method function) {
        this.function = function;
    }

    @Generated
    public void setPropertyDefinition(LinkedHashMap<String, String> propertyDefinition) {
        this.propertyDefinition = propertyDefinition;
    }

    @Generated
    public Object getFunctionHolder() {
        return this.functionHolder;
    }

    @Generated
    public Method getFunction() {
        return this.function;
    }

    @Generated
    public LinkedHashMap<String, String> getPropertyDefinition() {
        return this.propertyDefinition;
    }

    @Generated
    public ReflectionalToolFunction(Object functionHolder, Method function, LinkedHashMap<String, String> propertyDefinition) {
        this.functionHolder = functionHolder;
        this.function = function;
        this.propertyDefinition = propertyDefinition;
    }
}

