/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.flink.agents.runtime.python.event;

import org.apache.flink.agents.api.Event;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Map;
import java.util.UUID;

/** An event generated by the framework, passing a Python event to the Java agent runner. */
public class PythonEvent extends Event {
    private final byte[] event;
    private final String eventType;

    public PythonEvent(byte[] event, String eventType) {
        super();
        this.event = event;
        this.eventType = eventType;
    }

    @JsonCreator
    public PythonEvent(
            @JsonProperty("id") UUID id,
            @JsonProperty("attributes") Map<String, Object> attributes,
            @JsonProperty("event") byte[] event,
            @JsonProperty("eventType") String eventType) {
        super(id, attributes);
        this.event = event;
        this.eventType = eventType;
    }

    public byte[] getEvent() {
        return event;
    }

    public String getEventType() {
        return eventType;
    }
}
