/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;

@Internal
public class UrlEncodeFunction
extends BuiltInScalarFunction {
    public UrlEncodeFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.URL_ENCODE, context);
    }

    @Nullable
    public StringData eval(StringData url) {
        if (url == null) {
            return null;
        }
        Charset charset = StandardCharsets.UTF_8;
        try {
            return StringData.fromString((String)URLEncoder.encode(url.toString(), charset.name()));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

