/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Collections;
import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.sort.ComparatorCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.InputSortedExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.SortUtil;
import org.apache.flink.table.runtime.operators.sort.RankOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@ExecNodeMetadata(name="batch-exec-rank", version=1, producedTransformations={"rank"}, minPlanVersion=FlinkVersion.v2_0, minStateVersion=FlinkVersion.v2_0)
public class BatchExecRank
extends ExecNodeBase<RowData>
implements InputSortedExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String RANK_TRANSFORMATION = "rank";
    public static final String FIELD_NAME_PARTITION_FIELDS = "partitionFields";
    public static final String FIELD_NAME_SORT_FIELDS = "sortFields";
    public static final String FIELD_NAME_RANK_START = "rankStart";
    public static final String FIELD_NAME_RANK_END = "rankEnd";
    public static final String FIELD_NAME_OUTPUT_RANK_NUMBER = "outputRowNumber";
    @JsonProperty(value="partitionFields")
    private final int[] partitionFields;
    @JsonProperty(value="sortFields")
    private final int[] sortFields;
    @JsonProperty(value="rankStart")
    private final long rankStart;
    @JsonProperty(value="rankEnd")
    private final long rankEnd;
    @JsonProperty(value="outputRowNumber")
    private final boolean outputRankNumber;

    public BatchExecRank(ReadableConfig tableConfig, int[] partitionFields, int[] sortFields, long rankStart, long rankEnd, boolean outputRankNumber, InputProperty inputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecRank.class), ExecNodeContext.newPersistedConfig(BatchExecRank.class, tableConfig), Collections.singletonList(inputProperty), (LogicalType)outputType, description);
        this.partitionFields = partitionFields;
        this.sortFields = sortFields;
        this.rankStart = rankStart;
        this.rankEnd = rankEnd;
        this.outputRankNumber = outputRankNumber;
    }

    @JsonCreator
    public BatchExecRank(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="partitionFields") int[] partitionFields, @JsonProperty(value="sortFields") int[] sortFields, @JsonProperty(value="rankStart") long rankStart, @JsonProperty(value="rankEnd") long rankEnd, @JsonProperty(value="outputRowNumber") boolean outputRankNumber, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        this.partitionFields = partitionFields;
        this.sortFields = sortFields;
        this.rankStart = rankStart;
        this.rankEnd = rankEnd;
        this.outputRankNumber = outputRankNumber;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputType = (RowType)inputEdge.getOutputType();
        RankOperator operator = new RankOperator(ComparatorCodeGenerator.gen(config, planner.getFlinkContext().getClassLoader(), "PartitionByComparator", inputType, SortUtil.getAscendingSortSpec(this.partitionFields)), ComparatorCodeGenerator.gen(config, planner.getFlinkContext().getClassLoader(), "OrderByComparator", inputType, SortUtil.getAscendingSortSpec(this.sortFields)), this.rankStart, this.rankEnd, this.outputRankNumber);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(RANK_TRANSFORMATION, config), SimpleOperatorFactory.of((StreamOperator)operator), InternalTypeInfo.of((RowType)((RowType)this.getOutputType())), inputTransform.getParallelism(), false);
    }
}

