/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.servlet.RequestVariableResolver;

public abstract class AbstractServlet
extends HttpServlet {
    protected URL getResource(String path) {
        int index = path.indexOf(47, 1);
        if (index != -1 && path.substring(index).startsWith("/res/")) {
            return ((Object)((Object)this)).getClass().getResource(path.substring(index));
        }
        return null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.spoolResource(request, response);
    }

    public void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new ServletException("Render method not implemented");
    }

    protected final void spoolResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        URL url = this.getResource(request.getPathInfo());
        if (url == null) {
            return;
        }
        URLConnection connection = url.openConnection();
        try (InputStream ins = connection.getInputStream();){
            int rd;
            String contentType;
            if (ins == null) {
                return;
            }
            long lastModified = connection.getLastModified();
            if (lastModified > 0L) {
                long ifModifiedSince = request.getDateHeader("If-Modified-Since");
                if (ifModifiedSince >= lastModified / 1000L * 1000L) {
                    response.setStatus(304);
                    return;
                }
                response.setDateHeader("Last-Modified", lastModified);
            }
            if ((contentType = this.getServletContext().getMimeType(request.getPathInfo())) != null) {
                response.setContentType(contentType);
            }
            if (connection.getContentLength() != -1) {
                response.setContentLength(connection.getContentLength());
            }
            response.setStatus(200);
            ServletOutputStream out = response.getOutputStream();
            byte[] buf = new byte[2048];
            while ((rd = ins.read(buf)) >= 0) {
                out.write(buf, 0, rd);
            }
        }
    }

    protected final String readTemplateFile(String templateFile) throws IOException {
        return Util.readTemplateFile(((Object)((Object)this)).getClass(), templateFile);
    }

    protected RequestVariableResolver getVariableResolver(HttpServletRequest request) {
        return (RequestVariableResolver)request.getAttribute("felix.webconsole.variable.resolver");
    }

    public static final void setNoCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
        response.addHeader("Cache-Control", "must-revalidate");
        response.addHeader("Cache-Control", "max-age=0");
        response.setHeader("Expires", "Thu, 01 Jan 1970 01:00:00 GMT");
        response.setHeader("Pragma", "no-cache");
    }
}

