/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.felix.webconsole.bundleinfo.BundleInfo;
import org.apache.felix.webconsole.bundleinfo.BundleInfoProvider;
import org.apache.felix.webconsole.bundleinfo.BundleInfoType;
import org.apache.felix.webconsole.i18n.LocalizationHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

final class ServicesUsedInfoProvider
implements BundleInfoProvider {
    private final LocalizationHelper localization;

    ServicesUsedInfoProvider(Bundle bundle) {
        this.localization = new LocalizationHelper(bundle);
    }

    @Override
    public String getName(Locale locale) {
        return this.localization.getResourceBundle(locale).getString("services.info.name");
    }

    @Override
    public BundleInfo[] getBundleInfo(Bundle bundle, String webConsoleRoot, Locale locale) {
        ServiceReference[] refs = bundle.getServicesInUse();
        if (null == refs || refs.length == 0) {
            return NO_INFO;
        }
        BundleInfo[] ret = new BundleInfo[refs.length];
        for (int i = 0; i < refs.length; ++i) {
            ret[i] = this.toInfo(refs[i], webConsoleRoot, locale);
        }
        return ret;
    }

    private BundleInfo toInfo(ServiceReference<?> ref, String webConsoleRoot, Locale locale) {
        String[] classes = (String[])ref.getProperty("objectClass");
        Object id = ref.getProperty("service.id");
        String descr = this.localization.getResourceBundle(locale).getString("services.info.descr");
        String name = this.localization.getResourceBundle(locale).getString("services.info.key");
        name = MessageFormat.format(name, id, Arrays.asList(classes).toString());
        if (webConsoleRoot == null) {
            return new BundleInfo(name, id, BundleInfoType.VALUE, descr);
        }
        return new BundleInfo(name, webConsoleRoot + "/services/" + String.valueOf(id), BundleInfoType.LINK, descr);
    }

    ServiceRegistration<BundleInfoProvider> register(BundleContext context) {
        return context.registerService(BundleInfoProvider.class, (Object)this, null);
    }
}

