/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ajax;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONDateConvertor
implements JSON.Convertor {
    private static final Logger LOG = LoggerFactory.getLogger(JSONDateConvertor.class);
    private final AutoLock _lock = new AutoLock();
    private final boolean _fromJSON;
    private final DateCache _dateCache;
    private final SimpleDateFormat _format;

    public JSONDateConvertor() {
        this(false);
    }

    public JSONDateConvertor(boolean fromJSON) {
        this("EEE MMM dd HH:mm:ss zzz yyyy", TimeZone.getTimeZone("GMT"), fromJSON);
    }

    public JSONDateConvertor(String format, TimeZone zone, boolean fromJSON) {
        this._dateCache = new DateCache(format, null, zone);
        this._fromJSON = fromJSON;
        this._format = new SimpleDateFormat(format);
        this._format.setTimeZone(zone);
    }

    public JSONDateConvertor(String format, TimeZone zone, boolean fromJSON, Locale locale) {
        this._dateCache = new DateCache(format, locale, zone);
        this._fromJSON = fromJSON;
        this._format = new SimpleDateFormat(format, new DateFormatSymbols(locale));
        this._format.setTimeZone(zone);
    }

    @Override
    public Object fromJSON(Map<String, Object> map) {
        if (!this._fromJSON) {
            throw new UnsupportedOperationException();
        }
        AutoLock l = this._lock.lock();
        try {
            Object object = this._format.parseObject((String)map.get("value"));
            if (l != null) {
                l.close();
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (l != null) {
                    try {
                        l.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.warn("Unable to parse JSON Object", (Throwable)e);
                return null;
            }
        }
    }

    @Override
    public void toJSON(Object obj, JSON.Output out) {
        String date = this._dateCache.format((Date)obj);
        if (this._fromJSON) {
            out.addClass(obj.getClass());
            out.add("value", date);
        } else {
            out.add(date);
        }
    }
}

