/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.sampling.EbppsItemsSketch;
import org.apache.datasketches.sampling.PreambleUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EbppsItemsSketchTest {
    private static final double EPS = 1.0E-13;

    static EbppsItemsSketch<Integer> createUnweightedSketch(int k, long n) {
        EbppsItemsSketch sk = new EbppsItemsSketch(k);
        for (long i = 0L; i < n; ++i) {
            sk.update((Object)((int)i));
        }
        return sk;
    }

    static <T> void checkIfEqual(EbppsItemsSketch<T> sk1, EbppsItemsSketch<T> sk2) {
        Assert.assertEquals((int)sk1.getK(), (int)sk2.getK());
        Assert.assertEquals((long)sk1.getN(), (long)sk2.getN());
        Assert.assertEquals((double)sk1.getC(), (double)sk2.getC());
        Assert.assertEquals((double)sk1.getCumulativeWeight(), (double)sk2.getCumulativeWeight());
        ArrayList sample1 = sk1.getResult();
        ArrayList sample2 = sk2.getResult();
        if (sk1.getC() < 1.0) {
            if (sample1 != null && sample2 != null) {
                Assert.assertEquals((int)sample1.size(), (int)sample2.size());
                Assert.assertEquals(sample1.get(0), sample2.get(0));
            }
        } else {
            Assert.assertTrue((sample1 != null && sample2 != null ? 1 : 0) != 0);
            int len = Math.min(sample1.size(), sample2.size());
            for (int i = 0; i < len; ++i) {
                Assert.assertEquals(sample1.get(i), sample2.get(i));
            }
            Assert.assertTrue(((double)len == Math.floor(sk1.getC()) || (double)len == Math.ceil(sk1.getC()) ? 1 : 0) != 0);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkZeroK() {
        new EbppsItemsSketch(0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkTooBigK() {
        new EbppsItemsSketch(Integer.MAX_VALUE);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkNegativeWeight() {
        EbppsItemsSketch sk = new EbppsItemsSketch(1);
        sk.update((Object)"a", -1.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInfiniteWeight() {
        EbppsItemsSketch sk = new EbppsItemsSketch(1);
        sk.update((Object)"a", Double.POSITIVE_INFINITY);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkNaNWeight() {
        EbppsItemsSketch sk = new EbppsItemsSketch(1);
        sk.update((Object)"a", Double.NaN);
    }

    @Test
    public void insertItems() {
        int n = 0;
        int k = 5;
        EbppsItemsSketch<Integer> sk = EbppsItemsSketchTest.createUnweightedSketch(5, n);
        Assert.assertEquals((int)sk.getK(), (int)5);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((double)sk.getC(), (double)0.0);
        Assert.assertEquals((double)sk.getCumulativeWeight(), (double)0.0);
        Assert.assertTrue((boolean)sk.isEmpty());
        n = 5;
        sk = EbppsItemsSketchTest.createUnweightedSketch(5, n);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertEquals((long)sk.getN(), (long)n);
        Assert.assertEquals((double)sk.getC(), (double)5.0);
        Assert.assertEquals((double)sk.getCumulativeWeight(), (double)n);
        Assert.assertEquals((int)sk.getResult().size(), (int)sk.getK());
        for (Integer val : sk.getResult()) {
            Assert.assertTrue((val < n ? 1 : 0) != 0);
        }
        n = 50;
        sk = EbppsItemsSketchTest.createUnweightedSketch(5, n);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertEquals((long)sk.getN(), (long)n);
        Assert.assertEquals((double)sk.getCumulativeWeight(), (double)n);
        Assert.assertEquals((double)sk.getC(), (double)5.0, (double)1.0E-13);
        Assert.assertEquals((int)sk.getResult().size(), (int)sk.getK());
        for (Integer val : sk.getResult()) {
            Assert.assertTrue((val < n ? 1 : 0) != 0);
        }
        sk.update((Object)n, (double)n);
        Assert.assertTrue((sk.getC() < (double)sk.getK() ? 1 : 0) != 0);
    }

    @Test
    public void mergeSmallIntoLarge() {
        int k = 100;
        EbppsItemsSketch<Integer> sk1 = EbppsItemsSketchTest.createUnweightedSketch(100, 100L);
        EbppsItemsSketch sk2 = new EbppsItemsSketch(50);
        sk2.update((Object)-1, 10.0);
        sk1.merge(sk2);
        Assert.assertEquals((int)sk1.getK(), (int)50);
        Assert.assertEquals((long)sk1.getN(), (long)101L);
        Assert.assertTrue((sk1.getC() < 100.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)sk1.getCumulativeWeight(), (double)110.00000000000001, (double)1.0E-13);
    }

    @Test
    public void mergeLargeIntoSmall() {
        int k = 100;
        EbppsItemsSketch sk1 = new EbppsItemsSketch(50);
        sk1.update((Object)-1, 25.0);
        sk1.update((Object)-2, 12.5);
        EbppsItemsSketch<Integer> sk2 = EbppsItemsSketchTest.createUnweightedSketch(100, 100L);
        Assert.assertEquals((long)sk2.getN(), (long)100L);
        Assert.assertEquals((double)sk2.getC(), (double)100.0, (double)1.0E-13);
        sk1.merge(sk2);
        Assert.assertEquals((int)sk1.getK(), (int)50);
        Assert.assertEquals((long)sk1.getN(), (long)102L);
        Assert.assertTrue((sk1.getC() < 100.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)sk1.getCumulativeWeight(), (double)137.5, (double)1.0E-13);
    }

    @Test
    public void serializeDeserializeString() {
        int k = 10;
        EbppsItemsSketch sk = new EbppsItemsSketch(10);
        byte[] bytes = sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertEquals((int)bytes.length, (int)sk.getSerializedSizeBytes((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()));
        MemorySegment seg = MemorySegment.ofArray(bytes);
        EbppsItemsSketch sk_heapify = EbppsItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        EbppsItemsSketchTest.checkIfEqual(sk, sk_heapify);
        for (int i = 0; i < 10; ++i) {
            sk.update((Object)Integer.toString(i));
        }
        bytes = sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertEquals((int)bytes.length, (int)sk.getSerializedSizeBytes((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()));
        seg = MemorySegment.ofArray(bytes);
        sk_heapify = EbppsItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        EbppsItemsSketchTest.checkIfEqual(sk, sk_heapify);
        sk.update((Object)Integer.toString(20), 2.5);
        Assert.assertEquals((double)sk.getCumulativeWeight(), (double)12.5, (double)1.0E-13);
        bytes = sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertEquals((int)bytes.length, (int)sk.getSerializedSizeBytes((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()));
        seg = MemorySegment.ofArray(bytes);
        sk_heapify = EbppsItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        EbppsItemsSketchTest.checkIfEqual(sk, sk_heapify);
        Assert.assertNotNull((Object)sk.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void deserializeZeroK() {
        EbppsItemsSketch sk = new EbppsItemsSketch(5);
        byte[] bytes = sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        PreambleUtil.insertK((MemorySegment)seg, (int)0);
        EbppsItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void deserializeTooLargeK() {
        EbppsItemsSketch sk = new EbppsItemsSketch(5);
        byte[] bytes = sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        PreambleUtil.insertK((MemorySegment)seg, (int)Integer.MAX_VALUE);
        EbppsItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void deserializeBadSerVer() {
        EbppsItemsSketch sk = new EbppsItemsSketch(5);
        byte[] bytes = sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        PreambleUtil.insertSerVer((MemorySegment)seg, (int)-1);
        EbppsItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void deserializeBadFamily() {
        EbppsItemsSketch sk = new EbppsItemsSketch(5);
        byte[] bytes = sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        PreambleUtil.insertFamilyID((MemorySegment)seg, (int)0);
        EbppsItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void deserializeNegativeN() {
        EbppsItemsSketch sk = new EbppsItemsSketch(5);
        for (int i = 0; i < 10; ++i) {
            sk.update((Object)Integer.toString(i));
        }
        byte[] bytes = sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        PreambleUtil.insertN((MemorySegment)seg, (long)-1000L);
        EbppsItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void deserializeNaNCumulativeWeight() {
        EbppsItemsSketch sk = new EbppsItemsSketch(5);
        for (int i = 0; i < 10; ++i) {
            sk.update((Object)Integer.toString(i));
        }
        byte[] bytes = sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        PreambleUtil.insertEbppsCumulativeWeight((MemorySegment)seg, (double)Double.NaN);
        EbppsItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void deserializeInfiniteMaxWeight() {
        EbppsItemsSketch sk = new EbppsItemsSketch(5);
        for (int i = 0; i < 10; ++i) {
            sk.update((Object)Integer.toString(i));
        }
        byte[] bytes = sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        PreambleUtil.insertEbppsMaxWeight((MemorySegment)seg, (double)Double.POSITIVE_INFINITY);
        EbppsItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void deserializeNegativeRho() {
        EbppsItemsSketch sk = new EbppsItemsSketch(5);
        for (int i = 0; i < 10; ++i) {
            sk.update((Object)Integer.toString(i));
        }
        byte[] bytes = sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        PreambleUtil.insertEbppsRho((MemorySegment)seg, (double)-0.1);
        EbppsItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void deserializeNegativeC() {
        EbppsItemsSketch sk = new EbppsItemsSketch(5);
        for (int i = 0; i < 10; ++i) {
            sk.update((Object)Integer.toString(i));
        }
        byte[] bytes = sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        seg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, 40L, -2.0);
        EbppsItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void deserializeTooShort() {
        EbppsItemsSketch sk = new EbppsItemsSketch(5);
        for (long i = 0L; i < 10L; ++i) {
            sk.update((Object)i);
        }
        byte[] bytes = sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        MemorySegment shortSeg = seg.asSlice(0L, seg.byteSize() - 1L);
        EbppsItemsSketch.heapify((MemorySegment)shortSeg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
    }
}

