/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.text.lookup.DateStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DateStringLookupTest {
    DateStringLookupTest() {
    }

    @Test
    void testBadFormat() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateStringLookup.INSTANCE.apply("this-is-a-bad-format-dontcha-know"));
    }

    @Test
    void testDefault() throws ParseException {
        String formatted = DateStringLookup.INSTANCE.apply(null);
        DateFormat.getInstance().parse(formatted);
    }

    @Test
    void testFormat() {
        String format = "yyyy-MM-dd";
        String value = DateStringLookup.INSTANCE.apply("yyyy-MM-dd");
        Assertions.assertNotNull((Object)value, (String)"No Date");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String today = simpleDateFormat.format(new Date());
        Assertions.assertEquals((Object)value, (Object)today);
    }

    @Test
    void testToString() {
        Assertions.assertFalse((boolean)DateStringLookup.INSTANCE.toString().isEmpty());
    }
}

