/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.StringUtilsTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class StringUtilsTrimStripTest
extends AbstractLangTest {
    private static final String FOO = "foo";

    StringUtilsTrimStripTest() {
    }

    @Test
    void testStripAccents() {
        String cue = "\u00c7\u00fa\u00ea";
        Assertions.assertEquals((Object)"Cue", (Object)StringUtils.stripAccents((String)"\u00c7\u00fa\u00ea"), (String)"Failed to strip accents from \u00c7\u00fa\u00ea");
        String lots = "\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d9\u00da\u00db\u00dc\u00dd";
        Assertions.assertEquals((Object)"AAAAAACEEEEIIIINOOOOOUUUUY", (Object)StringUtils.stripAccents((String)"\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d9\u00da\u00db\u00dc\u00dd"), (String)"Failed to strip accents from \u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d9\u00da\u00db\u00dc\u00dd");
        Assertions.assertNull((Object)StringUtils.stripAccents(null), (String)"Failed null safety");
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripAccents((String)""), (String)"Failed empty String");
        Assertions.assertEquals((Object)"control", (Object)StringUtils.stripAccents((String)"control"), (String)"Failed to handle non-accented text");
        Assertions.assertEquals((Object)"eclair", (Object)StringUtils.stripAccents((String)"\u00e9clair"), (String)"Failed to handle easy example");
        Assertions.assertEquals((Object)"ALOSZZCND aloszzcnd", (Object)StringUtils.stripAccents((String)"\u0104\u0141\u00d3\u015a\u017b\u0179\u0106\u0143\u0110 \u0105\u0142\u00f3\u015b\u017c\u017a\u0107\u0144\u0111"));
        Assertions.assertEquals((Object)"The cafe\u2019s pinata gave me deja vu.", (Object)StringUtils.stripAccents((String)"The caf\u00e9\u2019s pi\u00f1ata gave me d\u00e9j\u00e0 vu."), (String)"Failed to handle accented text");
        Assertions.assertEquals((Object)"fluid quest", (Object)StringUtils.stripAccents((String)"\ufb02uid que\ufb06"), (String)"Failed to handle ligatures");
        Assertions.assertEquals((Object)"a b c 1 2 3", (Object)StringUtils.stripAccents((String)"\u1d43 \u1d47 \u1d9c \u00b9 \u00b2 \u00b3"), (String)"Failed to handle superscript text");
        Assertions.assertEquals((Object)"math italic", (Object)StringUtils.stripAccents((String)"\ud835\udc5a\ud835\udc4e\ud835\udc61\u210e \ud835\udc56\ud835\udc61\ud835\udc4e\ud835\udc59\ud835\udc56\ud835\udc50"), (String)"Failed to handle UTF32 example");
        Assertions.assertEquals((Object)"\ud83d\udf01 \ud83d\udf02 \ud83d\udf03 \ud83d\udf04", (Object)StringUtils.stripAccents((String)"\ud83d\udf01 \ud83d\udf02 \ud83d\udf03 \ud83d\udf04"), (String)"Failed to handle non-accented text");
    }

    @Test
    void testStripAccentsIWithBar() {
        Assertions.assertEquals((Object)"I i I i I", (Object)StringUtils.stripAccents((String)"\u0197 \u0268 \u1d7b \u1da4 \u1da7"));
    }

    @Test
    @Disabled
    void testStripAccentsKorean() {
        String input = "\uc78a\uc9c0\ub9c8 \ub10c \ud750\ub9b0 \uc5b4\ub460\uc0ac\uc774 \uc67c\uc190\uc73c\ub85c \uadf8\ub9b0 \ubcc4 \ud558\ub098";
        Assertions.assertEquals((Object)"\uc78a\uc9c0\ub9c8 \ub10c \ud750\ub9b0 \uc5b4\ub460\uc0ac\uc774 \uc67c\uc190\uc73c\ub85c \uadf8\ub9b0 \ubcc4 \ud558\ub098", (Object)StringUtils.stripAccents((String)"\uc78a\uc9c0\ub9c8 \ub10c \ud750\ub9b0 \uc5b4\ub460\uc0ac\uc774 \uc67c\uc190\uc73c\ub85c \uadf8\ub9b0 \ubcc4 \ud558\ub098"), (String)"Failed to handle Korean text");
    }

    @Test
    void testStripAccentsTWithStroke() {
        Assertions.assertEquals((Object)"T t", (Object)StringUtils.stripAccents((String)"\u0166 \u0167"));
    }

    @Test
    void testStripAccentsUnicodeVulgarFractions() {
        Assertions.assertEquals((Object)"1\u20444", (Object)StringUtils.stripAccents((String)"\u00bc"));
        Assertions.assertEquals((Object)"1\u20442", (Object)StringUtils.stripAccents((String)"\u00bd"));
        Assertions.assertEquals((Object)"3\u20444", (Object)StringUtils.stripAccents((String)"\u00be"));
    }

    @Test
    void testStripAccentsUWithBar() {
        Assertions.assertEquals((Object)"U u U u", (Object)StringUtils.stripAccents((String)"\u0244 \u0289 \u1d7e \u1db6"));
    }

    @Test
    void testStripAll() {
        Object[] empty = new String[]{};
        String[] fooSpace = new String[]{"  foo  ", "  foo", "foo  "};
        String[] fooDots = new String[]{"..foo..", "..foo", "foo.."};
        Object[] foo = new String[]{FOO, FOO, FOO};
        Assertions.assertNull((Object)StringUtils.stripAll((String[])null));
        Assertions.assertArrayEquals((Object[])empty, (Object[])StringUtils.stripAll((String[])new String[0]));
        Assertions.assertArrayEquals((Object[])new String[]{null}, (Object[])StringUtils.stripAll((String[])new String[]{null}));
        Assertions.assertArrayEquals((Object[])empty, (Object[])StringUtils.stripAll((String[])empty));
        Assertions.assertArrayEquals((Object[])foo, (Object[])StringUtils.stripAll((String[])fooSpace));
        Assertions.assertNull((Object)StringUtils.stripAll(null, null));
        Assertions.assertArrayEquals((Object[])foo, (Object[])StringUtils.stripAll((String[])fooSpace, null));
        Assertions.assertArrayEquals((Object[])foo, (Object[])StringUtils.stripAll((String[])fooDots, (String)"."));
    }

    @Test
    void testStripEndStringString() {
        Assertions.assertNull((Object)StringUtils.stripEnd(null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"        ", null));
        Assertions.assertEquals((Object)"  abc", (Object)StringUtils.stripEnd((String)"  abc  ", null));
        Assertions.assertEquals((Object)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE), (Object)StringUtils.stripEnd((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), null));
        Assertions.assertNull((Object)StringUtils.stripEnd(null, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"", (String)""));
        Assertions.assertEquals((Object)"        ", (Object)StringUtils.stripEnd((String)"        ", (String)""));
        Assertions.assertEquals((Object)"  abc  ", (Object)StringUtils.stripEnd((String)"  abc  ", (String)""));
        Assertions.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.stripEnd((String)StringUtilsTest.WHITESPACE, (String)""));
        Assertions.assertNull((Object)StringUtils.stripEnd(null, (String)" "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"", (String)" "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"        ", (String)" "));
        Assertions.assertEquals((Object)"  abc", (Object)StringUtils.stripEnd((String)"  abc  ", (String)" "));
        Assertions.assertNull((Object)StringUtils.stripEnd(null, (String)"ab"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripEnd((String)"", (String)"ab"));
        Assertions.assertEquals((Object)"        ", (Object)StringUtils.stripEnd((String)"        ", (String)"ab"));
        Assertions.assertEquals((Object)"  abc  ", (Object)StringUtils.stripEnd((String)"  abc  ", (String)"ab"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.stripEnd((String)"abcabab", (String)"ab"));
        Assertions.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.stripEnd((String)StringUtilsTest.WHITESPACE, (String)""));
    }

    @Test
    void testStripStartStringString() {
        Assertions.assertNull((Object)StringUtils.stripStart(null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"        ", null));
        Assertions.assertEquals((Object)"abc  ", (Object)StringUtils.stripStart((String)"  abc  ", null));
        Assertions.assertEquals((Object)(StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), (Object)StringUtils.stripStart((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), null));
        Assertions.assertNull((Object)StringUtils.stripStart(null, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"", (String)""));
        Assertions.assertEquals((Object)"        ", (Object)StringUtils.stripStart((String)"        ", (String)""));
        Assertions.assertEquals((Object)"  abc  ", (Object)StringUtils.stripStart((String)"  abc  ", (String)""));
        Assertions.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.stripStart((String)StringUtilsTest.WHITESPACE, (String)""));
        Assertions.assertNull((Object)StringUtils.stripStart(null, (String)" "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"", (String)" "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"        ", (String)" "));
        Assertions.assertEquals((Object)"abc  ", (Object)StringUtils.stripStart((String)"  abc  ", (String)" "));
        Assertions.assertNull((Object)StringUtils.stripStart(null, (String)"ab"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripStart((String)"", (String)"ab"));
        Assertions.assertEquals((Object)"        ", (Object)StringUtils.stripStart((String)"        ", (String)"ab"));
        Assertions.assertEquals((Object)"  abc  ", (Object)StringUtils.stripStart((String)"  abc  ", (String)"ab"));
        Assertions.assertEquals((Object)"cabab", (Object)StringUtils.stripStart((String)"abcabab", (String)"ab"));
        Assertions.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.stripStart((String)StringUtilsTest.WHITESPACE, (String)""));
    }

    @Test
    void testStripString() {
        Assertions.assertNull((Object)StringUtils.strip(null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)"        "));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.strip((String)"  abc  "));
        Assertions.assertEquals((Object)StringUtilsTest.NON_WHITESPACE, (Object)StringUtils.strip((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE)));
    }

    @Test
    void testStripStringString() {
        Assertions.assertNull((Object)StringUtils.strip(null, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)"        ", null));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.strip((String)"  abc  ", null));
        Assertions.assertEquals((Object)StringUtilsTest.NON_WHITESPACE, (Object)StringUtils.strip((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), null));
        Assertions.assertNull((Object)StringUtils.strip(null, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)"", (String)""));
        Assertions.assertEquals((Object)"        ", (Object)StringUtils.strip((String)"        ", (String)""));
        Assertions.assertEquals((Object)"  abc  ", (Object)StringUtils.strip((String)"  abc  ", (String)""));
        Assertions.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.strip((String)StringUtilsTest.WHITESPACE, (String)""));
        Assertions.assertNull((Object)StringUtils.strip(null, (String)" "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)"", (String)" "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)"        ", (String)" "));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.strip((String)"  abc  ", (String)" "));
        Assertions.assertNull((Object)StringUtils.strip(null, (String)"ab"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.strip((String)"", (String)"ab"));
        Assertions.assertEquals((Object)"        ", (Object)StringUtils.strip((String)"        ", (String)"ab"));
        Assertions.assertEquals((Object)"  abc  ", (Object)StringUtils.strip((String)"  abc  ", (String)"ab"));
        Assertions.assertEquals((Object)"c", (Object)StringUtils.strip((String)"abcabab", (String)"ab"));
        Assertions.assertEquals((Object)StringUtilsTest.WHITESPACE, (Object)StringUtils.strip((String)StringUtilsTest.WHITESPACE, (String)""));
    }

    @Test
    void testStripToEmptyString() {
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripToEmpty(null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripToEmpty((String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripToEmpty((String)"        "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.stripToEmpty((String)StringUtilsTest.WHITESPACE));
        Assertions.assertEquals((Object)"ab c", (Object)StringUtils.stripToEmpty((String)"  ab c  "));
        Assertions.assertEquals((Object)StringUtilsTest.NON_WHITESPACE, (Object)StringUtils.stripToEmpty((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE)));
    }

    @Test
    void testStripToNullString() {
        Assertions.assertNull((Object)StringUtils.stripToNull(null));
        Assertions.assertNull((Object)StringUtils.stripToNull((String)""));
        Assertions.assertNull((Object)StringUtils.stripToNull((String)"        "));
        Assertions.assertNull((Object)StringUtils.stripToNull((String)StringUtilsTest.WHITESPACE));
        Assertions.assertEquals((Object)"ab c", (Object)StringUtils.stripToNull((String)"  ab c  "));
        Assertions.assertEquals((Object)StringUtilsTest.NON_WHITESPACE, (Object)StringUtils.stripToNull((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE)));
    }

    @Test
    void testTrim() {
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trim((String)"foo  "));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trim((String)" foo  "));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trim((String)" foo"));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trim((String)FOO));
        Assertions.assertEquals((Object)"", (Object)StringUtils.trim((String)" \t\r\n\b "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.trim((String)StringUtilsTest.TRIMMABLE));
        Assertions.assertEquals((Object)StringUtilsTest.NON_TRIMMABLE, (Object)StringUtils.trim((String)StringUtilsTest.NON_TRIMMABLE));
        Assertions.assertEquals((Object)"", (Object)StringUtils.trim((String)""));
        Assertions.assertNull((Object)StringUtils.trim(null));
    }

    @Test
    void testTrimToEmpty() {
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToEmpty((String)"foo  "));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToEmpty((String)" foo  "));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToEmpty((String)" foo"));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToEmpty((String)FOO));
        Assertions.assertEquals((Object)"", (Object)StringUtils.trimToEmpty((String)" \t\r\n\b "));
        Assertions.assertEquals((Object)"", (Object)StringUtils.trimToEmpty((String)StringUtilsTest.TRIMMABLE));
        Assertions.assertEquals((Object)StringUtilsTest.NON_TRIMMABLE, (Object)StringUtils.trimToEmpty((String)StringUtilsTest.NON_TRIMMABLE));
        Assertions.assertEquals((Object)"", (Object)StringUtils.trimToEmpty((String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.trimToEmpty(null));
    }

    @Test
    void testTrimToNull() {
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToNull((String)"foo  "));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToNull((String)" foo  "));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToNull((String)" foo"));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.trimToNull((String)FOO));
        Assertions.assertNull((Object)StringUtils.trimToNull((String)" \t\r\n\b "));
        Assertions.assertNull((Object)StringUtils.trimToNull((String)StringUtilsTest.TRIMMABLE));
        Assertions.assertEquals((Object)StringUtilsTest.NON_TRIMMABLE, (Object)StringUtils.trimToNull((String)StringUtilsTest.NON_TRIMMABLE));
        Assertions.assertNull((Object)StringUtils.trimToNull((String)""));
        Assertions.assertNull((Object)StringUtils.trimToNull(null));
    }
}

