/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// MavenSpecApplyConfiguration represents a declarative configuration of the MavenSpec type for use
// with apply.
type MavenSpecApplyConfiguration struct {
	LocalRepository  *string                           `json:"localRepository,omitempty"`
	Properties       map[string]string                 `json:"properties,omitempty"`
	Profiles         []ValueSourceApplyConfiguration   `json:"profiles,omitempty"`
	Settings         *ValueSourceApplyConfiguration    `json:"settings,omitempty"`
	SettingsSecurity *ValueSourceApplyConfiguration    `json:"settingsSecurity,omitempty"`
	CASecrets        []corev1.SecretKeySelector        `json:"caSecrets,omitempty"`
	Extension        []MavenArtifactApplyConfiguration `json:"extension,omitempty"`
	CLIOptions       []string                          `json:"cliOptions,omitempty"`
}

// MavenSpecApplyConfiguration constructs a declarative configuration of the MavenSpec type for use with
// apply.
func MavenSpec() *MavenSpecApplyConfiguration {
	return &MavenSpecApplyConfiguration{}
}

// WithLocalRepository sets the LocalRepository field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LocalRepository field is set to the value of the last call.
func (b *MavenSpecApplyConfiguration) WithLocalRepository(value string) *MavenSpecApplyConfiguration {
	b.LocalRepository = &value
	return b
}

// WithProperties puts the entries into the Properties field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Properties field,
// overwriting an existing map entries in Properties field with the same key.
func (b *MavenSpecApplyConfiguration) WithProperties(entries map[string]string) *MavenSpecApplyConfiguration {
	if b.Properties == nil && len(entries) > 0 {
		b.Properties = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Properties[k] = v
	}
	return b
}

// WithProfiles adds the given value to the Profiles field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Profiles field.
func (b *MavenSpecApplyConfiguration) WithProfiles(values ...*ValueSourceApplyConfiguration) *MavenSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithProfiles")
		}
		b.Profiles = append(b.Profiles, *values[i])
	}
	return b
}

// WithSettings sets the Settings field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Settings field is set to the value of the last call.
func (b *MavenSpecApplyConfiguration) WithSettings(value *ValueSourceApplyConfiguration) *MavenSpecApplyConfiguration {
	b.Settings = value
	return b
}

// WithSettingsSecurity sets the SettingsSecurity field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SettingsSecurity field is set to the value of the last call.
func (b *MavenSpecApplyConfiguration) WithSettingsSecurity(value *ValueSourceApplyConfiguration) *MavenSpecApplyConfiguration {
	b.SettingsSecurity = value
	return b
}

// WithCASecrets adds the given value to the CASecrets field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the CASecrets field.
func (b *MavenSpecApplyConfiguration) WithCASecrets(values ...corev1.SecretKeySelector) *MavenSpecApplyConfiguration {
	for i := range values {
		b.CASecrets = append(b.CASecrets, values[i])
	}
	return b
}

// WithExtension adds the given value to the Extension field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Extension field.
func (b *MavenSpecApplyConfiguration) WithExtension(values ...*MavenArtifactApplyConfiguration) *MavenSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithExtension")
		}
		b.Extension = append(b.Extension, *values[i])
	}
	return b
}

// WithCLIOptions adds the given value to the CLIOptions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the CLIOptions field.
func (b *MavenSpecApplyConfiguration) WithCLIOptions(values ...string) *MavenSpecApplyConfiguration {
	for i := range values {
		b.CLIOptions = append(b.CLIOptions, values[i])
	}
	return b
}
