/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.jdbc.core.ADBDatatype;
import org.apache.asterix.jdbc.core.ADBErrorReporter;
import org.apache.asterix.jdbc.core.ADBResultSet;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.core.JsonParser;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.core.JsonToken;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.module.SimpleModule;

public final class ADBRowStore {
    static final char TEXT_DELIMITER = ':';
    private static final String ROW_STORE_ATTR_NAME = ADBRowStore.class.getSimpleName();
    private static final int FLOAT_NAN_BITS = Float.floatToIntBits(Float.NaN);
    private static final int FLOAT_POSITIVE_ZERO_BITS = Float.floatToIntBits(0.0f);
    private static final int FLOAT_NEGATIVE_ZERO_BITS = Float.floatToIntBits(-0.0f);
    private static final long DOUBLE_NAN_BITS = Double.doubleToLongBits(Double.NaN);
    private static final long DOUBLE_POSITIVE_ZERO_BITS = Double.doubleToLongBits(0.0);
    private static final long DOUBLE_NEGATIVE_ZERO_BITS = Double.doubleToLongBits(-0.0);
    static final Map<Class<?>, GetObjectFunction> OBJECT_ACCESSORS_ATOMIC = ADBRowStore.createAtomicObjectAccessorMap();
    static final List<Class<?>> GET_OBJECT_NON_ATOMIC = Arrays.asList(Collection.class, List.class, Map.class);
    private static final ZoneId TZ_UTC = ZoneId.of("UTC");
    private final ADBResultSet resultSet;
    private final ADBDatatype[] columnTypes;
    private final Object[] objectStore;
    private final long[] registerStore;
    private final TimeZone tzSystem = TimeZone.getDefault();
    private int parsedLength;
    private long currentDateChronon;
    private JsonGenerator jsonGen;
    private StringWriter jsonGenBuffer;

    public ADBRowStore(ADBResultSet resultSet, int initialColumnCount) {
        this.resultSet = Objects.requireNonNull(resultSet);
        this.columnTypes = new ADBDatatype[initialColumnCount];
        this.objectStore = new Object[initialColumnCount];
        this.registerStore = new long[initialColumnCount * 2];
    }

    void reset() {
        Arrays.fill((Object[])this.columnTypes, (Object)ADBDatatype.MISSING);
        Arrays.fill(this.registerStore, 0L);
        Arrays.fill(this.objectStore, null);
    }

    private void setColumnType(int columnIndex, ADBDatatype columnType) {
        this.columnTypes[columnIndex] = columnType;
    }

    ADBDatatype getColumnType(int columnIndex) {
        return this.columnTypes[columnIndex];
    }

    void putColumn(int columnIndex, char[] textChars, int textOffset, int textLength) throws SQLException {
        byte valueTypeTag = this.parseTypeTag(textChars, textOffset, textLength);
        ADBDatatype valueType = ADBDatatype.findByTypeTag(valueTypeTag);
        if (valueType == null) {
            throw this.getErrorReporter().errorUnexpectedType(valueTypeTag);
        }
        int nonTaggedOffset = textOffset + this.parsedLength;
        int nonTaggedLength = textLength - this.parsedLength;
        int nonTaggedEnd = nonTaggedOffset + nonTaggedLength;
        this.setColumnType(columnIndex, valueType);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                break;
            }
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case YEARMONTHDURATION: 
            case DAYTIMEDURATION: {
                long r0 = this.parseInt64(textChars, nonTaggedOffset, nonTaggedEnd);
                this.setColumnRegisters(columnIndex, r0, 0L);
                break;
            }
            case STRING: {
                this.objectStore[columnIndex] = new String(textChars, nonTaggedOffset, nonTaggedLength);
                break;
            }
            case DURATION: {
                int delimiterOffset = ADBRowStore.indexOf(':', textChars, nonTaggedOffset, nonTaggedEnd);
                if (delimiterOffset < 0 || delimiterOffset == nonTaggedEnd - 1) {
                    throw this.getErrorReporter().errorInProtocol();
                }
                long r0 = this.parseInt64(textChars, nonTaggedOffset, delimiterOffset);
                long r1 = this.parseInt64(textChars, delimiterOffset + 1, nonTaggedEnd);
                this.setColumnRegisters(columnIndex, r0, r1);
                break;
            }
            case UUID: {
                this.objectStore[columnIndex] = UUID.fromString(new String(textChars, nonTaggedOffset, nonTaggedLength));
                break;
            }
            case OBJECT: 
            case ARRAY: 
            case MULTISET: {
                throw new IllegalArgumentException(String.valueOf((Object)valueType));
            }
            default: {
                throw this.getErrorReporter().errorUnexpectedType(valueType);
            }
        }
    }

    void putNullColumn(int columnIndex) {
        this.setColumnType(columnIndex, ADBDatatype.NULL);
    }

    void putBooleanColumn(int columnIndex, boolean value) {
        this.setColumnType(columnIndex, ADBDatatype.BOOLEAN);
        this.setColumnRegisters(columnIndex, value ? 1L : 0L, 0L);
    }

    void putInt64Column(int columnIndex, long value) {
        this.setColumnType(columnIndex, ADBDatatype.BIGINT);
        this.setColumnRegisters(columnIndex, value, 0L);
    }

    void putArrayColumn(int columnIndex, List<?> value) {
        this.setColumnType(columnIndex, ADBDatatype.ARRAY);
        this.objectStore[columnIndex] = Objects.requireNonNull(value);
    }

    void putRecordColumn(int columnIndex, Map<?, ?> value) {
        this.setColumnType(columnIndex, ADBDatatype.OBJECT);
        this.objectStore[columnIndex] = Objects.requireNonNull(value);
    }

    private void setColumnRegisters(int columnIndex, long r0, long r1) {
        int registerPos = columnIndex * 2;
        this.registerStore[registerPos] = r0;
        this.registerStore[++registerPos] = r1;
    }

    private long getColumnRegister(int columnIndex, int registerIndex) {
        int registerPos = columnIndex * 2;
        switch (registerIndex) {
            case 0: {
                break;
            }
            case 1: {
                ++registerPos;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.registerStore[registerPos];
    }

    private boolean getColumnRegisterAsBoolean(int columnIndex, int registerIndex) {
        return this.getColumnRegister(columnIndex, registerIndex) != 0L;
    }

    private byte getColumnRegisterAsByte(int columnIndex, int registerIndex) {
        return (byte)this.getColumnRegister(columnIndex, registerIndex);
    }

    private short getColumnRegisterAsShort(int columnIndex, int registerIndex) {
        return (short)this.getColumnRegister(columnIndex, registerIndex);
    }

    private int getColumnRegisterAsInt(int columnIndex, int registerIndex) {
        return (int)this.getColumnRegister(columnIndex, registerIndex);
    }

    private float getColumnRegisterAsFloat(int columnIndex, int registerIndex) {
        return Float.intBitsToFloat(this.getColumnRegisterAsFloatBits(columnIndex, registerIndex));
    }

    private boolean isColumnRegisterZeroOrNanFloat(int columnIndex, int registerIndex) {
        int bits = this.getColumnRegisterAsFloatBits(columnIndex, registerIndex);
        return bits == FLOAT_POSITIVE_ZERO_BITS || bits == FLOAT_NEGATIVE_ZERO_BITS || bits == FLOAT_NAN_BITS;
    }

    private int getColumnRegisterAsFloatBits(int columnIndex, int registerIndex) {
        return this.getColumnRegisterAsInt(columnIndex, registerIndex);
    }

    private double getColumnRegisterAsDouble(int columnIndex, int registerIndex) {
        return Double.longBitsToDouble(this.getColumnRegisterAsDoubleBits(columnIndex, registerIndex));
    }

    private boolean isColumnRegisterZeroOrNanDouble(int columnIndex, int registerIndex) {
        long bits = this.getColumnRegisterAsDoubleBits(columnIndex, registerIndex);
        return bits == DOUBLE_POSITIVE_ZERO_BITS || bits == DOUBLE_NEGATIVE_ZERO_BITS || bits == DOUBLE_NAN_BITS;
    }

    private long getColumnRegisterAsDoubleBits(int columnIndex, int registerIndex) {
        return this.getColumnRegister(columnIndex, registerIndex);
    }

    private Period getColumnRegisterAsPeriod(int columnIndex, int registerIndex) {
        return Period.ofMonths((int)this.getColumnRegister(columnIndex, registerIndex));
    }

    private Duration getColumnRegisterAsDuration(int columnIndex, int registerIndex) {
        return Duration.ofMillis((int)this.getColumnRegister(columnIndex, registerIndex));
    }

    private Number getNumberFromObjectStore(int columnIndex) {
        Number n;
        Object o = this.objectStore[columnIndex];
        if (o != null) {
            return (Number)o;
        }
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case TINYINT: {
                n = this.getColumnRegisterAsByte(columnIndex, 0);
                break;
            }
            case SMALLINT: {
                n = this.getColumnRegisterAsShort(columnIndex, 0);
                break;
            }
            case INTEGER: {
                n = this.getColumnRegisterAsInt(columnIndex, 0);
                break;
            }
            case BIGINT: {
                n = this.getColumnRegister(columnIndex, 0);
                break;
            }
            case FLOAT: {
                n = Float.valueOf(this.getColumnRegisterAsFloat(columnIndex, 0));
                break;
            }
            case DOUBLE: {
                n = this.getColumnRegisterAsDouble(columnIndex, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)valueType));
            }
        }
        this.objectStore[columnIndex] = n;
        return n;
    }

    private String getStringFromObjectStore(int columnIndex) {
        return (String)this.objectStore[columnIndex];
    }

    private UUID getUUIDFromObjectStore(int columnIndex) {
        return (UUID)this.objectStore[columnIndex];
    }

    private Period getPeriodFromObjectStore(int columnIndex) {
        Object o = this.objectStore[columnIndex];
        if (o != null) {
            return (Period)o;
        }
        ADBDatatype valueType = this.getColumnType(columnIndex);
        if (valueType != ADBDatatype.YEARMONTHDURATION) {
            throw new IllegalArgumentException(String.valueOf((Object)valueType));
        }
        Period v = this.getColumnRegisterAsPeriod(columnIndex, 0);
        this.objectStore[columnIndex] = v;
        return v;
    }

    private Duration getDurationFromObjectStore(int columnIndex) {
        Object o = this.objectStore[columnIndex];
        if (o != null) {
            return (Duration)o;
        }
        ADBDatatype valueType = this.getColumnType(columnIndex);
        if (valueType != ADBDatatype.DAYTIMEDURATION) {
            throw new IllegalArgumentException(String.valueOf((Object)valueType));
        }
        Duration v = this.getColumnRegisterAsDuration(columnIndex, 0);
        this.objectStore[columnIndex] = v;
        return v;
    }

    private String getISODurationStringFromObjectStore(int columnIndex) {
        Object o = this.objectStore[columnIndex];
        if (o != null) {
            return (String)o;
        }
        ADBDatatype valueType = this.getColumnType(columnIndex);
        if (valueType != ADBDatatype.DURATION) {
            throw new IllegalArgumentException(String.valueOf((Object)valueType));
        }
        String v = this.getColumnRegisterAsPeriod(columnIndex, 0).toString() + this.getColumnRegisterAsDuration(columnIndex, 1).toString().substring(1);
        this.objectStore[columnIndex] = v;
        return v;
    }

    boolean getBoolean(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return false;
            }
            case BOOLEAN: {
                return this.getColumnRegisterAsBoolean(columnIndex, 0);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return this.getColumnRegister(columnIndex, 0) != 0L;
            }
            case FLOAT: {
                return !this.isColumnRegisterZeroOrNanFloat(columnIndex, 0);
            }
            case DOUBLE: {
                return !this.isColumnRegisterZeroOrNanDouble(columnIndex, 0);
            }
            case STRING: {
                return Boolean.parseBoolean(this.getStringFromObjectStore(columnIndex));
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    byte getByte(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return 0;
            }
            case BOOLEAN: {
                return (byte)(this.getColumnRegisterAsBoolean(columnIndex, 0) ? 1 : 0);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return this.getColumnRegisterAsByte(columnIndex, 0);
            }
            case FLOAT: {
                return (byte)this.getColumnRegisterAsFloat(columnIndex, 0);
            }
            case DOUBLE: {
                return (byte)this.getColumnRegisterAsDouble(columnIndex, 0);
            }
            case STRING: {
                return (byte)this.parseInt64(this.getStringFromObjectStore(columnIndex));
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    short getShort(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return 0;
            }
            case BOOLEAN: {
                return (short)(this.getColumnRegisterAsBoolean(columnIndex, 0) ? 1 : 0);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return this.getColumnRegisterAsShort(columnIndex, 0);
            }
            case FLOAT: {
                return (short)this.getColumnRegisterAsFloat(columnIndex, 0);
            }
            case DOUBLE: {
                return (short)this.getColumnRegisterAsDouble(columnIndex, 0);
            }
            case STRING: {
                return (short)this.parseInt64(this.getStringFromObjectStore(columnIndex));
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    int getInt(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return 0;
            }
            case BOOLEAN: {
                return this.getColumnRegisterAsBoolean(columnIndex, 0) ? 1 : 0;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DATE: 
            case TIME: 
            case YEARMONTHDURATION: {
                return this.getColumnRegisterAsInt(columnIndex, 0);
            }
            case FLOAT: {
                return (int)this.getColumnRegisterAsFloat(columnIndex, 0);
            }
            case DOUBLE: {
                return (int)this.getColumnRegisterAsDouble(columnIndex, 0);
            }
            case STRING: {
                return (int)this.parseInt64(this.getStringFromObjectStore(columnIndex));
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    long getLong(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return 0L;
            }
            case BOOLEAN: {
                return this.getColumnRegisterAsBoolean(columnIndex, 0) ? 1L : 0L;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case YEARMONTHDURATION: 
            case DAYTIMEDURATION: {
                return this.getColumnRegister(columnIndex, 0);
            }
            case FLOAT: {
                return (long)this.getColumnRegisterAsFloat(columnIndex, 0);
            }
            case DOUBLE: {
                return (long)this.getColumnRegisterAsDouble(columnIndex, 0);
            }
            case STRING: {
                return this.parseInt64(this.getStringFromObjectStore(columnIndex));
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    float getFloat(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return 0.0f;
            }
            case BOOLEAN: {
                return this.getColumnRegisterAsBoolean(columnIndex, 0) ? 1.0f : 0.0f;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return this.getColumnRegister(columnIndex, 0);
            }
            case FLOAT: {
                return this.getColumnRegisterAsFloat(columnIndex, 0);
            }
            case DOUBLE: {
                return (float)this.getColumnRegisterAsDouble(columnIndex, 0);
            }
            case STRING: {
                try {
                    return Float.parseFloat(this.getStringFromObjectStore(columnIndex));
                }
                catch (NumberFormatException e) {
                    throw this.getErrorReporter().errorInvalidValueOfType(valueType);
                }
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    double getDouble(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return 0.0;
            }
            case BOOLEAN: {
                return this.getColumnRegisterAsBoolean(columnIndex, 0) ? 1.0 : 0.0;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return this.getColumnRegister(columnIndex, 0);
            }
            case FLOAT: {
                return this.getColumnRegisterAsFloat(columnIndex, 0);
            }
            case DOUBLE: {
                return this.getColumnRegisterAsDouble(columnIndex, 0);
            }
            case STRING: {
                try {
                    return Double.parseDouble(this.getStringFromObjectStore(columnIndex));
                }
                catch (NumberFormatException e) {
                    throw this.getErrorReporter().errorInvalidValueOfType(valueType);
                }
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(columnIndex, false, 0);
    }

    BigDecimal getBigDecimal(int columnIndex, boolean setScale, int scale) throws SQLException {
        BigDecimal dec;
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                dec = this.getColumnRegisterAsBoolean(columnIndex, 0) ? BigDecimal.ONE : BigDecimal.ZERO;
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case YEARMONTHDURATION: 
            case DAYTIMEDURATION: {
                dec = BigDecimal.valueOf(this.getColumnRegister(columnIndex, 0));
                break;
            }
            case FLOAT: {
                try {
                    dec = new BigDecimal(this.getColumnRegisterAsFloat(columnIndex, 0));
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.getErrorReporter().errorInvalidValueOfType(valueType);
                }
            }
            case DOUBLE: {
                try {
                    dec = new BigDecimal(this.getColumnRegisterAsDouble(columnIndex, 0));
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.getErrorReporter().errorInvalidValueOfType(valueType);
                }
            }
            case STRING: {
                try {
                    dec = new BigDecimal(this.getStringFromObjectStore(columnIndex));
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.getErrorReporter().errorInvalidValueOfType(valueType);
                }
            }
            default: {
                throw this.getErrorReporter().errorUnexpectedType(valueType);
            }
        }
        return setScale ? dec.setScale(scale, RoundingMode.DOWN) : dec;
    }

    private Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    Date getDate(int columnIndex, Calendar cal) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case DATE: {
                return this.toDateFromDateChronon(this.getColumnRegister(columnIndex, 0), this.getTimeZone(cal, this.tzSystem));
            }
            case DATETIME: {
                return this.toDateFromDatetimeChronon(this.getColumnRegister(columnIndex, 0), this.getTimeZone(cal, this.tzSystem));
            }
            case STRING: {
                try {
                    LocalDate d = LocalDate.parse(this.getStringFromObjectStore(columnIndex));
                    return new Date(d.getYear() - 1900, d.getMonthValue() - 1, d.getDayOfMonth());
                }
                catch (DateTimeParseException e) {
                    throw this.getErrorReporter().errorInvalidValueOfType(valueType);
                }
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    LocalDate getLocalDate(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case DATE: {
                return this.toLocalDateFromDateChronon(this.getColumnRegister(columnIndex, 0));
            }
            case DATETIME: {
                return this.toLocalDateFromDatetimeChronon(this.getColumnRegister(columnIndex, 0));
            }
            case STRING: {
                try {
                    return LocalDate.parse(this.getStringFromObjectStore(columnIndex));
                }
                catch (DateTimeParseException e) {
                    throw this.getErrorReporter().errorInvalidValueOfType(valueType);
                }
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    private Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    Time getTime(int columnIndex, Calendar cal) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case TIME: {
                return this.toTimeFromTimeChronon(this.getColumnRegister(columnIndex, 0), this.getTimeZone(cal, this.tzSystem));
            }
            case DATETIME: {
                return this.toTimeFromDatetimeChronon(this.getColumnRegister(columnIndex, 0), this.getTimeZone(cal, this.tzSystem));
            }
            case STRING: {
                try {
                    LocalTime t = LocalTime.parse(this.getStringFromObjectStore(columnIndex));
                    return this.toTimeFromTimeChronon(TimeUnit.NANOSECONDS.toMillis(t.toNanoOfDay()), this.getTimeZone(cal, this.tzSystem));
                }
                catch (DateTimeParseException e) {
                    throw this.getErrorReporter().errorInvalidValueOfType(valueType);
                }
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    LocalTime getLocalTime(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case TIME: {
                return this.toLocalTimeFromTimeChronon(this.getColumnRegister(columnIndex, 0));
            }
            case DATETIME: {
                return this.toLocalTimeFromDatetimeChronon(this.getColumnRegister(columnIndex, 0));
            }
            case STRING: {
                try {
                    return LocalTime.parse(this.getStringFromObjectStore(columnIndex));
                }
                catch (DateTimeParseException e) {
                    throw this.getErrorReporter().errorInvalidValueOfType(valueType);
                }
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    private Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case DATE: {
                return this.toTimestampFromDateChronon(this.getColumnRegister(columnIndex, 0), this.getTimeZone(cal, this.tzSystem));
            }
            case DATETIME: {
                return this.toTimestampFromDatetimeChronon(this.getColumnRegister(columnIndex, 0), this.getTimeZone(cal, this.tzSystem));
            }
            case STRING: {
                try {
                    Instant i = Instant.parse(this.getStringFromObjectStore(columnIndex));
                    long millis0 = TimeUnit.SECONDS.toMillis(i.getEpochSecond());
                    long millis1 = TimeUnit.NANOSECONDS.toMillis(i.getNano());
                    return new Timestamp(millis0 + millis1);
                }
                catch (DateTimeParseException e) {
                    throw this.getErrorReporter().errorInvalidValueOfType(valueType);
                }
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    LocalDateTime getLocalDateTime(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case DATE: {
                return this.toLocalDateTimeFromDateChronon(this.getColumnRegister(columnIndex, 0));
            }
            case DATETIME: {
                return this.toLocalDateTimeFromDatetimeChronon(this.getColumnRegister(columnIndex, 0));
            }
            case STRING: {
                try {
                    return LocalDateTime.parse(this.getStringFromObjectStore(columnIndex));
                }
                catch (DateTimeParseException e) {
                    throw this.getErrorReporter().errorInvalidValueOfType(valueType);
                }
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    Period getPeriod(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case YEARMONTHDURATION: {
                return this.getPeriodFromObjectStore(columnIndex);
            }
            case DURATION: {
                return this.getColumnRegisterAsPeriod(columnIndex, 0);
            }
            case STRING: {
                try {
                    return Period.parse(this.getStringFromObjectStore(columnIndex));
                }
                catch (DateTimeParseException e) {
                    throw this.getErrorReporter().errorInvalidValueOfType(valueType);
                }
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    Duration getDuration(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case DAYTIMEDURATION: {
                return this.getDurationFromObjectStore(columnIndex);
            }
            case DURATION: {
                return this.getColumnRegisterAsDuration(columnIndex, 1);
            }
            case STRING: {
                try {
                    return Duration.parse(this.getStringFromObjectStore(columnIndex));
                }
                catch (DateTimeParseException e) {
                    throw this.getErrorReporter().errorInvalidValueOfType(valueType);
                }
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    byte[] getBinary(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case STRING: {
                return this.getStringFromObjectStore(columnIndex).getBytes(StandardCharsets.UTF_8);
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    UUID getUUID(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case UUID: {
                return this.getUUIDFromObjectStore(columnIndex);
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    String getString(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return Boolean.toString(this.getColumnRegisterAsBoolean(columnIndex, 0));
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return Long.toString(this.getColumnRegister(columnIndex, 0));
            }
            case FLOAT: {
                return Float.toString(this.getColumnRegisterAsFloat(columnIndex, 0));
            }
            case DOUBLE: {
                return Double.toString(this.getColumnRegisterAsDouble(columnIndex, 0));
            }
            case DATE: {
                return this.toLocalDateFromDateChronon(this.getColumnRegister(columnIndex, 0)).toString();
            }
            case TIME: {
                return this.toLocalTimeFromTimeChronon(this.getColumnRegister(columnIndex, 0)).toString();
            }
            case DATETIME: {
                return this.toLocalDateTimeFromDatetimeChronon(this.getColumnRegister(columnIndex, 0)).toString();
            }
            case YEARMONTHDURATION: {
                return this.getPeriodFromObjectStore(columnIndex).toString();
            }
            case DAYTIMEDURATION: {
                return this.getDurationFromObjectStore(columnIndex).toString();
            }
            case DURATION: {
                return this.getISODurationStringFromObjectStore(columnIndex);
            }
            case STRING: {
                return this.getStringFromObjectStore(columnIndex);
            }
            case UUID: {
                return this.getUUIDFromObjectStore(columnIndex).toString();
            }
            case OBJECT: 
            case ARRAY: {
                return this.printAsJson(this.objectStore[columnIndex]);
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    Reader getCharacterStream(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case STRING: {
                return new StringReader(this.getStringFromObjectStore(columnIndex));
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    InputStream getInputStream(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case STRING: {
                return new ByteArrayInputStream(this.getStringFromObjectStore(columnIndex).getBytes(StandardCharsets.UTF_8));
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    Object getObject(int columnIndex) throws SQLException {
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return this.getColumnRegisterAsBoolean(columnIndex, 0);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                return this.getNumberFromObjectStore(columnIndex);
            }
            case DATE: {
                return this.toDateFromDateChronon(this.getColumnRegister(columnIndex, 0), this.tzSystem);
            }
            case TIME: {
                return this.toTimeFromTimeChronon(this.getColumnRegister(columnIndex, 0), this.tzSystem);
            }
            case DATETIME: {
                return this.toTimestampFromDatetimeChronon(this.getColumnRegister(columnIndex, 0), this.tzSystem);
            }
            case YEARMONTHDURATION: {
                return this.getPeriodFromObjectStore(columnIndex);
            }
            case DAYTIMEDURATION: {
                return this.getDurationFromObjectStore(columnIndex);
            }
            case DURATION: {
                return this.getISODurationStringFromObjectStore(columnIndex);
            }
            case STRING: {
                return this.getStringFromObjectStore(columnIndex);
            }
            case UUID: {
                return this.getUUIDFromObjectStore(columnIndex);
            }
            case OBJECT: 
            case ARRAY: {
                return this.objectStore[columnIndex];
            }
        }
        throw this.getErrorReporter().errorUnexpectedType(valueType);
    }

    <T> T getObject(int columnIndex, Class<T> targetType) throws SQLException {
        Object v;
        ADBDatatype valueType = this.getColumnType(columnIndex);
        switch (valueType) {
            case MISSING: 
            case NULL: {
                return null;
            }
        }
        GetObjectFunction getter = OBJECT_ACCESSORS_ATOMIC.get(targetType);
        if (getter != null) {
            v = getter.getObject(this, columnIndex);
        } else if (GET_OBJECT_NON_ATOMIC.contains(targetType)) {
            v = this.getObject(columnIndex);
        } else {
            throw this.getErrorReporter().errorUnexpectedType(targetType);
        }
        return targetType.cast(v);
    }

    private static Map<Class<?>, GetObjectFunction> createAtomicObjectAccessorMap() {
        HashMap map = new HashMap();
        map.put(Boolean.TYPE, ADBRowStore::getBoolean);
        map.put(Boolean.class, ADBRowStore::getBoolean);
        map.put(Byte.TYPE, ADBRowStore::getByte);
        map.put(Byte.class, ADBRowStore::getByte);
        map.put(Short.TYPE, ADBRowStore::getShort);
        map.put(Short.class, ADBRowStore::getShort);
        map.put(Integer.TYPE, ADBRowStore::getInt);
        map.put(Integer.class, ADBRowStore::getInt);
        map.put(Long.TYPE, ADBRowStore::getLong);
        map.put(Long.class, ADBRowStore::getLong);
        map.put(Float.TYPE, ADBRowStore::getFloat);
        map.put(Float.class, ADBRowStore::getFloat);
        map.put(Double.TYPE, ADBRowStore::getDouble);
        map.put(Double.class, ADBRowStore::getDouble);
        map.put(BigDecimal.class, ADBRowStore::getBigDecimal);
        map.put(Date.class, ADBRowStore::getDate);
        map.put(LocalDate.class, ADBRowStore::getLocalDate);
        map.put(Time.class, ADBRowStore::getTime);
        map.put(LocalTime.class, ADBRowStore::getLocalTime);
        map.put(Timestamp.class, ADBRowStore::getTimestamp);
        map.put(LocalDateTime.class, ADBRowStore::getLocalDateTime);
        map.put(Period.class, ADBRowStore::getPeriod);
        map.put(Duration.class, ADBRowStore::getDuration);
        map.put(UUID.class, ADBRowStore::getUUID);
        map.put(String.class, ADBRowStore::getString);
        return map;
    }

    private Date toDateFromDateChronon(long dateChrononInDays, TimeZone tz) {
        return new Date(this.getDatetimeChrononAdjusted(TimeUnit.DAYS.toMillis(dateChrononInDays), tz));
    }

    private Date toDateFromDatetimeChronon(long datetimeChrononInMillis, TimeZone tz) {
        return new Date(this.getDatetimeChrononAdjusted(datetimeChrononInMillis, tz));
    }

    private LocalDate toLocalDateFromDateChronon(long dateChrononInDays) {
        return LocalDate.ofEpochDay(dateChrononInDays);
    }

    private LocalDate toLocalDateFromDatetimeChronon(long datetimeChrononInMillis) {
        return this.toLocalDateTimeFromDatetimeChronon(datetimeChrononInMillis).toLocalDate();
    }

    private Time toTimeFromTimeChronon(long timeChrononInMillis, TimeZone tz) {
        long datetimeChrononInMillis = this.getCurrentDateChrononInMillis() + timeChrononInMillis;
        return new Time(this.getDatetimeChrononAdjusted(datetimeChrononInMillis, tz));
    }

    private Time toTimeFromDatetimeChronon(long datetimeChrononInMillis, TimeZone tz) {
        return new Time(this.getDatetimeChrononAdjusted(datetimeChrononInMillis, tz));
    }

    private LocalTime toLocalTimeFromTimeChronon(long timeChrononInMillis) {
        return LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(timeChrononInMillis));
    }

    private LocalTime toLocalTimeFromDatetimeChronon(long datetimeChrononInMillis) {
        return this.toLocalDateTimeFromDatetimeChronon(datetimeChrononInMillis).toLocalTime();
    }

    private Timestamp toTimestampFromDatetimeChronon(long datetimeChrononInMillis, TimeZone tz) {
        return new Timestamp(this.getDatetimeChrononAdjusted(datetimeChrononInMillis, tz));
    }

    private Timestamp toTimestampFromDateChronon(long dateChrononInDays, TimeZone tz) {
        return new Timestamp(this.getDatetimeChrononAdjusted(TimeUnit.DAYS.toMillis(dateChrononInDays), tz));
    }

    private LocalDateTime toLocalDateTimeFromDatetimeChronon(long datetimeChrononInMillis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(datetimeChrononInMillis), TZ_UTC);
    }

    private LocalDateTime toLocalDateTimeFromDateChronon(long dateChrononInDays) {
        return LocalDate.ofEpochDay(dateChrononInDays).atStartOfDay();
    }

    private long getDatetimeChrononAdjusted(long datetimeChrononInMillis, TimeZone tz) {
        int tzOffset = tz.getOffset(datetimeChrononInMillis);
        return datetimeChrononInMillis - (long)tzOffset;
    }

    private long getCurrentDateChrononInMillis() {
        if (this.currentDateChronon == 0L) {
            this.currentDateChronon = TimeUnit.DAYS.toMillis(TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis()));
        }
        return this.currentDateChronon;
    }

    private TimeZone getTimeZone(Calendar cal, TimeZone tzDefault) {
        return cal != null ? cal.getTimeZone() : tzDefault;
    }

    private String printAsJson(Object value) throws SQLException {
        if (this.jsonGenBuffer == null) {
            this.jsonGenBuffer = new StringWriter();
            try {
                this.jsonGen = this.resultSet.metadata.statement.connection.protocol.getDriverContext().getGenericObjectWriter().getFactory().createGenerator(this.jsonGenBuffer);
            }
            catch (IOException e) {
                throw this.getErrorReporter().errorInResultHandling(e);
            }
        }
        try {
            this.jsonGen.writeObject(value);
            this.jsonGen.flush();
            String e = this.jsonGenBuffer.getBuffer().toString();
            return e;
        }
        catch (IOException e) {
            throw this.getErrorReporter().errorInResultHandling(e);
        }
        finally {
            this.jsonGenBuffer.getBuffer().setLength(0);
        }
    }

    ObjectReader createComplexColumnObjectReader(ObjectReader templateReader) {
        return templateReader.withAttribute(ROW_STORE_ATTR_NAME, this);
    }

    static void configureADMFormatDeserialization(ObjectMapper objectMapper, SimpleModule serdeModule) {
        objectMapper.configure(DeserializationFeature.USE_LONG_FOR_INTS, true);
        serdeModule.setDeserializerModifier(ADBRowStore.createADMFormatDeserializerModifier());
    }

    private static BeanDeserializerModifier createADMFormatDeserializerModifier() {
        return new BeanDeserializerModifier(){

            @Override
            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                if (String.class.equals((Object)beanDesc.getClassInfo().getAnnotated())) {
                    ADBRowStore rowStore = (ADBRowStore)config.getAttributes().getAttribute(ROW_STORE_ATTR_NAME);
                    return rowStore.createADMFormatStringDeserializer();
                }
                return deserializer;
            }
        };
    }

    private JsonDeserializer<?> createADMFormatStringDeserializer() {
        return new JsonDeserializer<Object>(){

            @Override
            public Object deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
                if (!parser.hasToken(JsonToken.VALUE_STRING)) {
                    throw new IOException("Unexpected token");
                }
                try {
                    ADBRowStore.this.reset();
                    ADBRowStore.this.putColumn(0, parser.getTextCharacters(), parser.getTextOffset(), parser.getTextLength());
                    return ADBRowStore.this.getObject(0);
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    private long parseInt64(CharSequence buffer) throws SQLException {
        return this.parseInt64(buffer, 0, buffer.length(), CharSequence::charAt);
    }

    private long parseInt64(char[] buffer, int begin, int end) throws SQLException {
        return this.parseInt64(buffer, begin, end, (input, index) -> input[index]);
    }

    private <T> long parseInt64(T buffer, int begin, int end, ICharAccessor<T> charAccessor) throws SQLException {
        if (end < begin) {
            throw new IllegalArgumentException();
        }
        boolean positive = true;
        long value = 0L;
        int offset = begin;
        char c = charAccessor.charAt(buffer, offset);
        if (c == '+') {
            ++offset;
        } else if (c == '-') {
            ++offset;
            positive = false;
        }
        try {
            while (offset < end) {
                c = charAccessor.charAt(buffer, offset);
                if (c < '0' || c > '9') {
                    throw this.getErrorReporter().errorInProtocol(String.valueOf(c));
                }
                value = Math.addExact(Math.multiplyExact(value, 10L), (long)(48 - c));
                ++offset;
            }
            if (positive) {
                value = Math.multiplyExact(value, -1L);
            }
            return value;
        }
        catch (ArithmeticException e) {
            throw this.getErrorReporter().errorInProtocol();
        }
    }

    private byte parseTypeTag(char[] textChars, int textOffset, int textLength) throws SQLException {
        if (textLength == 0) {
            this.parsedLength = 0;
            return ADBDatatype.STRING.getTypeTag();
        }
        if (textChars[textOffset] == ':') {
            this.parsedLength = 1;
            return ADBDatatype.STRING.getTypeTag();
        }
        int typeTagLength = 2;
        if (textLength < typeTagLength) {
            throw this.getErrorReporter().errorInProtocol();
        }
        byte parsedTypeTag = this.getByteFromValidHexChars(textChars[textOffset], textChars[textOffset + 1]);
        if (parsedTypeTag == ADBDatatype.MISSING.getTypeTag() || parsedTypeTag == ADBDatatype.NULL.getTypeTag()) {
            this.parsedLength = typeTagLength;
            return parsedTypeTag;
        }
        int delimiterLength = 1;
        if (textLength < typeTagLength + delimiterLength) {
            throw this.getErrorReporter().errorInProtocol();
        }
        if (textChars[textOffset + typeTagLength] != ':') {
            throw this.getErrorReporter().errorInProtocol();
        }
        this.parsedLength = typeTagLength + delimiterLength;
        return parsedTypeTag;
    }

    private byte getByteFromValidHexChars(char c0, char c1) throws SQLException {
        return (byte)((this.getValueFromValidHexChar(c0) << 4) + this.getValueFromValidHexChar(c1));
    }

    private int getValueFromValidHexChar(char c) throws SQLException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        throw this.getErrorReporter().errorInProtocol(String.valueOf(c));
    }

    private static int indexOf(char c, char[] array, int begin, int end) {
        for (int i = begin; i < end; ++i) {
            if (array[i] != c) continue;
            return i;
        }
        return -1;
    }

    private ADBErrorReporter getErrorReporter() {
        return this.resultSet.getErrorReporter();
    }

    static interface GetObjectFunction {
        public Object getObject(ADBRowStore var1, int var2) throws SQLException;
    }

    @FunctionalInterface
    public static interface ICharAccessor<T> {
        public char charAt(T var1, int var2);
    }
}

